% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/IRD.R
\docType{class}
\name{IRDSwaption-class}
\alias{IRDSwaption}
\title{IRD Swaption Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency set that the trade belongs to}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}

\item{OptionType}{Takes the values of either 'Put' or 'Call'}

\item{UnderlyingPrice}{The current price of the underlying}

\item{StrikePrice}{The strike price of the option}
}
\value{
An object of type IRDSwaption
}
\description{
Creates an IRD Swaption Object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}
\examples{
# the Swaption trade given in the Basel regulation IRD example
tr3 = IRDSwaption(Notional=5000,MtM=50,Currency="EUR",Si=1,Ei=11,BuySell='Sell',
OptionType='Put',UnderlyingPrice=0.06,StrikePrice=0.05)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm
}

