% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/trustRegion.R
\name{trustRegion}
\alias{trustRegion}
\title{Perform trust region refinement}
\usage{
trustRegion(cobra)
}
\arguments{
\item{cobra}{an object of class \code{cobra}, which is basically a list  (see \code{\link{cobraInit}})}
}
\value{
the modified \code{cobra} with new/updated elements
   \describe{
     \item{TRDONE}{ logical, is \code{TRUE} if there are more than d+1 points in the trusted
           region and thus surrogates can be trained. Otherwise \code{FALSE}.}
     \item{refinedX}{ if \code{TRDONE==TRUE} the refined solution from the trust-region run,
           otherwise \code{NA} }
   }
   If \code{TRDONE==TRUE} the relevant lists and counters  (\code{A,Fres,df,...})
   of \code{cobra} will be updated in \code{\link{cobraPhaseII}} as well.
}
\description{
If \code{cobra$TrustRegion==TRUE}  (see \code{\link{cobraInit}}), then \code{trustRegion}
is called after every iteration in order to refine the best solution so far.
This function builds a local model around the best solution and runs a local search in the trust region
to refine the best solution and find a better solution in the neighborhood.
}
\author{
Samineh Bagheri (\email{samineh.bagheri@fh-koeln.de})
}

