% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_auxiliary.R
\name{plot_betavar}
\alias{plot_betavar}
\title{Plots a beta variable}
\usage{
plot_betavar(m, sd, label = NULL, is_logit = FALSE, color = "black")
}
\arguments{
\item{m}{A vector of means of the distribution.}

\item{sd}{A vector of standard deviations of the distribution.}

\item{label}{Name of the variable to be used as x-axis label.}

\item{is_logit}{Logical that indicates whether the means and standard deviations are in
logit (TRUE) or normal (FALSE) space.}

\item{color}{A vector of colors.}
}
\value{
A plot of the probability distribution function. Vertical dotted line
indicates mean of distribution. This function can plot multiple curves when multiple means
and standard deviations are provided.
}
\description{
Plots the probability distribution function of a beta variable from the
mean and standard deviation in either transformed (logit) or untransformed space.
}
\examples{
mu <- 0.5
stddev <- 0.1
plot_betavar(mu, stddev) # mean of plot should be 0.5

#logit parameters
mu <- 0
stddev <- 0.1
plot_betavar(mu, stddev, is_logit = TRUE) # mean of plot should be 0.5
}
\seealso{
\code{\link{plot_lognormalvar}} \code{\link{plot_steepness}}
}
\author{
Q. Huynh
}
