% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_exists.R
\name{schema_exists}
\alias{schema_exists}
\title{Test if a schema exists in given connection}
\usage{
schema_exists(conn, schema)
}
\arguments{
\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{schema}{(\code{character(1)})\cr
The schema name to test existence for.}
}
\value{
TRUE if the given schema is found on \code{conn}.
}
\description{
Test if a schema exists in given connection
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  conn <- get_connection()

  schema_exists(conn, "test")

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
