% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSWD.R
\name{mergeSWD}
\alias{mergeSWD}
\title{Merge SWD Objects}
\usage{
mergeSWD(swd1, swd2)
}
\arguments{
\item{swd1}{\linkS4class{SWD} object.}

\item{swd2}{\linkS4class{SWD} object.}
}
\value{
The merged \linkS4class{SWD} object.
}
\description{
Merge two \linkS4class{SWD} object.
}
\details{
In case the two \linkS4class{SWD} objects have different columns,
only the common columns are used in the merged object.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(presence, test = 0.2)
train <- datasets[[1]]
test <- datasets[[2]]

# Merge the training and the testing datasets together
merged <- mergeSWD(train, test)
}
\author{
Sergio Vignali
}
