% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineLength.r
\name{lineLength}
\alias{lineLength}
\title{Line length}
\usage{
lineLength(x, byid = FALSE)
}
\arguments{
\item{x}{A spatial object inheriting from \code{SpatialLines}, \code{SpatialPolygons}, 
or \code{SpatialPoints}.}

\item{byid}{Whether to return lengths of individual spatial objects (TRUE) 
or the sum of all length (FALSE).}
}
\value{
If \code{byid==TRUE}, a vector containing the lengths of individual 
spatial objects 
(the points, lines, or polygons) is returned.  If \code{byid=FALSE}, 
the total length of all spatial objects is returned (a single number). 

If \code{x} inherits from \code{SpatialPoints}, returned 
value is 0.  If \code{x} inherits from \code{SpatialLines}, returned 
value contains line lengths or the sum of line lengths in \code{x}. 
If \code{x} inherits from \code{SpatialPolygons}, returned
value contains lengths of the perimeter of all polygons, or 
the sum of perimeters, in \code{x}. When \code{x} contains polygons with 
holes, the perimeter of the holes is included (i.e., perimeter of holes
is positive, not negative).    


Units of the returned value are same as units of coordinates 
in \code{x}.  E.g., 
meters if coordinates in \code{x} are UTM meters, 
decimal degrees if coordinates in \code{x} are lat-long decimal 
degrees.
}
\description{
An all-R routine that computes total length of all 
lines in a \code{SpatialLines*} object.
}
\details{
Provides the same answer as \code{rgeos::gLength}, but is 
all-R (does not require rgeos Java library) and does not 
fire a warning if \code{x} is un-projected (i.e., lat-long).
}
\examples{

# Length of Hawaii coastline, in kilometers
l <- lineLength( HI.coast ) / 1000

}
\author{
Trent McDonald
}
\seealso{
\code{sp::SpatialLines-class}
}

