% Generated by roxygen2 (4.0.2): do not edit by hand
\name{adx}
\alias{adx}
\title{Absolute Difference for Pairs - AD(x)}
\usage{
adx(x, g1, g2, d, s, ymax, xlab, color)
}
\arguments{
\item{x}{a column vector of scores on which the AD(x) is conditioned}

\item{g1}{a column vector of equated scores based on a single subpopulation (aligned with elements in x)}

\item{g2}{a column vector of equated scores based on a different single subpopulation (aligned with elements in x)}

\item{d}{a scalar of the difference that matters}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized adx)}

\item{ymax}{A maximum value for the y axis of the plot (default = 3 + the maximum AD(x) value)}

\item{xlab}{A label for the x axis of the plot (default = Score Scale)}

\item{color}{color of AD(x) line and points on plot (default = red)}
}
\value{
A data frame of AD(x) indices, conditioned on the score scale

A plot of the AD(x) indices in reference to the difference that matters
}
\description{
The absolute difference index, \eqn{AD(x)}{AD(x)}, is the absolute value of the simple arithmetic difference between one subpopulation's conditional equated score, \eqn{y_j(x)}{y_j(x)},and another subpopulation's conditional equated score, \eqn{y_{j'}(x)}{y_j'(x)}.  Formally,
\deqn{AD(x)=\frac{\mid y_j(x) - y_{j'}(x) \mid}{\sigma_x},}{AD(x)=|y_j(x) - y_j'(x)|/s,}
where \eqn{x}{x} is a score on the original (i.e., not equated) scale, and \eqn{\sigma_x}{s} is the standard deviation of \eqn{x}{x} scores in the (sub)population of interest. It is considered a pairwise, conditional invariance method. It was adapted by Huggins and Penfield (2012) from the analogous unconditional index, \eqn{MAD}{MAD}, presented by Kolen and Brennan (2004). It provides practitioners with the magnitude of equated score differences between a pair of subpopulations at each level of the original scale.
}
\examples{
#Unstandardized AD(x) for subpopulation 1 and subpopulation 2 in the example data set, ex.data
adx(x=ex.data[,1],g1=ex.data[,3],g2=ex.data[,4],d=.5)

#Unstandardized AD(x) for subpopulation 1 and subpopulation 2 in the example data set, ex.data, 
#with adjustments to the maximum y-axis on the plot, a new xlabel, and points/line in blue.
adx(x=ex.data[,1],g1=ex.data[,3],g2=ex.data[,4],d=.5,ymax=2,xlab="AD(x)",color="blue")

#Unstandardized AD(x) for subpopulation 4 and subpopulation 5 in the example data set, ex.data
adx(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],d=.5)

#Standardized AD(x) for subpopulation 4 and subpopulation 5 in the example data set, ex.data
adx(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],d=.5,s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Huggins, A.C., & Penfield, R.D. (2012). An NCME instructional module on population invariance in linking and equating. Educational Measurement: Issues and Practices, 31, 27-40.}
\item{Kolen, M.J., & Brennan, R.L. (2004). Test equating, scaling, and linking: Methods and practices (2nd ed.). NY: Springer.}
}
}
\seealso{
\code{\link{madp}}
}

