% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestralID.R
\name{createAncestralIdentifier}
\alias{createAncestralIdentifier}
\title{Create an ancestral identification function.}
\usage{
createAncestralIdentifier(idFunc, sources, targets, node, htrSources,
  ancestralSubset, cComponent)
}
\arguments{
\item{idFunc}{identification of edge coefficients often requires that other
edge coefficients already be identified. This argument should be a
function that produces all such identifications. The newly created
identifier function will return these identifications along with its
own.}

\item{sources}{the sources of the half-trek system.}

\item{targets}{the targets of the half-trek system (these should be the
parents of node).}

\item{node}{the node for which all incoming edges are to be identified
(the tails of which are targets).}

\item{htrSources}{the nodes in sources which are half-trek reachable from
node. All incoming edges to these sources should be identified by
idFunc for the newly created identification function to work.}

\item{ancestralSubset}{an ancestral subset of the graph containing node.}

\item{cComponent}{a list corresponding to the c-component containing node
in the subgraph induced by ancestralSubset. See
\code{\link{tianDecompose}} for how such c-component lists are formed.}
}
\value{
an identification function
}
\description{
A helper function for ancestralIdentifyStep, creates an identifier function
based on its given parameters. This created identifier function will
identify the directed edges from 'targets' to 'node.'
}
