% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesianLayman.R
\name{bayesianLayman}
\alias{bayesianLayman}
\title{Calculate Layman metrics on Bayesian postrior samples of a community}
\usage{
bayesianLayman(mu.post)
}
\arguments{
\item{mu.post}{a list of length n.communities, with each list element 
containing the estimated means of the groups comprising that community. The
typical workflow to generate mu.post follows. The 
Bayesian ellipses are fitted using \code{\link{siberEllipses}}, then the 
posterior means (centre of mass of each group) is extracted using
\code{\link{extractPosteriorMeans}}. See the example below.}
}
\value{
A list of length n.communities, with each element containing a 
matrix of 6 columns, each representing the Bayesian posterior distribution 
of the 6 Layman metrics for each of the posterior draws recorded by the 
fitting process (i.e. which determines the number of rows in this matrix).
}
\description{
This function loops over the posterior distribution of group means within
each community and generates the corresponding Bayesian estimate of the 6 
Layman metrics.
}

