% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{calcBeeGRMIbd}
\alias{calcBeeGRMIbd}
\title{Calculate Genomic Relatedness Matrix (GRM) for honeybees from
  Identical By Descent genomic data}
\usage{
calcBeeGRMIbd(x)
}
\arguments{
\item{x}{\code{\link{matrix}} of haplotypes/genomes with allele indicators
for the founders coded as 1, 2, ... Haplotypes/genome are in rows and sites
are in columns; no missing values are allowed (this is not checked!). Row
names are essential (formated as ind_genome as returned by AlphaSimR IBD
functions) to infer the individual and their ploidy (see examples)!}
}
\value{
a list with a matrix of gametic relatedness coefficients (genome) and
  a matrix of individual relatedness coefficients (indiv)
}
\description{
Level 0 function that returns Genomic Relatedness Matrix (GRM)
  for honeybees from Identical By Descent genomic data (tracked alleles
  since the founders) - see references on the background theory.
}
\examples{
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
SP$setTrackRec(TRUE)
SP$setTrackPed(isTrackPed = TRUE)

basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 1, nDrones = nFathersPoisson)
colony <- createColony(basePop[2])
colony <- cross(x = colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)

haploQ <- getQueenIbdHaplo(colony)
haploW <- getWorkersIbdHaplo(colony)
haploD <- getDronesIbdHaplo(colony)
SP$pedigree

haplo <- rbind(haploQ, haploW, haploD)

GRMs <- calcBeeGRMIbd(x = haplo)
# You can visualise this matrix with the image() functions from the "Matrix" package

# Inspect the diagonal of the relationship matrix between individuals
x <- diag(GRMs$indiv)
hist(x)
summary(x)

 # Inspect the off-diagonal of the relationship matrix between individuals
x <- GRMs$indiv[lower.tri(x = GRMs$indiv, diag = FALSE)]
hist(x)
summary(x)

ids <- getCasteId(colony)
qI <- ids$queen
wI <- sort(ids$workers)
dI <- sort(ids$drones)

qG <- c(t(outer(X = qI, Y = 1:2, FUN = paste, sep = "_")))
wG <- c(t(outer(X = wI, Y = 1:2, FUN = paste, sep = "_")))
dG <- paste(dI, 1, sep = "_")

# Queen vs workers
GRMs$genome[wG, qG]
GRMs$indiv[wI, qI]

# Queen vs drones
GRMs$genome[dG, qG]
GRMs$indiv[dI, qI]

# Workers vs workers
GRMs$genome[wG, wG]
GRMs$indiv[wI, wI]

# Workers vs drones
GRMs$genome[dG, wG]
GRMs$indiv[dI, wI]
}
\references{
Grossman and Eisen (1989) Inbreeding, coancestry, and covariance between
  relatives for X-chromosomal loci. The Journal of Heredity,
  \doi{/10.1093/oxfordjournals.jhered.a110812}

Fernando and Grossman (1989) Covariance between relatives for X-chromosomal
  loci in a population in disequilibrium. Theoretical and Applied Genetics,
  \doi{/10.1007/bf00305821}

Fernando and Grossman (1990) Genetic evaluation with autosomal
  and X-chromosomal inheritance. Theoretical and Applied Genetics,
 \doi{/10.1007/bf00224018}

Van Arendonk, Tier, and Kinghorn (1994) Use of multiple genetic markers in
  prediction of breeding values. Genetics,
 \doi{/10.1093/genetics/137.1.319}

Hill and Weir (2011) Variation in actual relationship as a consequence of
  Mendelian sampling and linkage. Genetics Research,
  \doi{/10.1017/s0016672310000480}
}
