% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.TrainedSLOPE}
\alias{plot.TrainedSLOPE}
\title{Plot results from cross-validation}
\usage{
\method{plot}{TrainedSLOPE}(
  x,
  measure = c("auto", "mse", "mae", "deviance", "auc", "misclass"),
  plot_min = TRUE,
  ci_alpha = 0.2,
  ci_border = FALSE,
  ci_col = "salmon",
  ...
)
}
\arguments{
\item{x}{an object of class \code{'TrainedSLOPE'}, typically from a call
to \code{\link[=trainSLOPE]{trainSLOPE()}}}

\item{measure}{any of the measures used in the call to \code{\link[=trainSLOPE]{trainSLOPE()}}. If
\code{measure = "auto"} then deviance will be used for binomial and multinomial
models, whilst mean-squared error will be used for Gaussian and Poisson
models.}

\item{plot_min}{whether to mark the location of the penalty corresponding
to the best prediction score}

\item{ci_alpha}{alpha (opacity) for fill in confidence limits}

\item{ci_border}{color (or flag to turn off and on) the border of the
confidence limits}

\item{ci_col}{color for border of confidence limits}

\item{...}{words}
}
\value{
An object of class \code{"ggplot"}, which will be plotted on the
current device unless stored in a variable.
}
\description{
Plot results from cross-validation
}
\examples{
# Cross-validation for a SLOPE binomial model
set.seed(123)
tune <- trainSLOPE(subset(mtcars, select = c("mpg", "drat", "wt")),
  mtcars$hp,
  q = c(0.1, 0.2),
  number = 10
)
plot(tune, ci_col = "salmon")
}
\seealso{
\code{\link[=trainSLOPE]{trainSLOPE()}}

Other model-tuning: 
\code{\link{caretSLOPE}()},
\code{\link{trainSLOPE}()}
}
\concept{model-tuning}
