% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMNlmec.est.R
\name{SMNlmec.est}
\alias{SMNlmec.est}
\title{Bayesian Censored Mixed-Effects Models with Damped Exponential Correlation Structures for Scale Mixture of Normal distributions error}
\usage{
SMNlmec.est(
  ID,
  x_set,
  z_set,
  tt,
  y_complete,
  censor_vector,
  dist = "Normal",
  struc = "UNC",
  direction = "left",
  thin_num = 1,
  chains_num = 1,
  iter_num = 3000,
  burn_percen = 0.1,
  seed_set = NULL,
  adapt_delta_set = 0.8
)
}
\arguments{
\item{ID}{Vector \code{N x 1} of the ID of the data set, specifying the ID for each measurement.}

\item{x_set}{Design matrix of the fixed effects of order \code{N x p}.}

\item{z_set}{Design matrix of the random effects of order \code{N x d}.}

\item{tt}{Vector \code{N x 1} with the time the measurements were made, where \code{N} is the total number of measurements for all individuals. Default it's considered regular times.}

\item{y_complete}{Vector \code{N x 1} of the complete responses.}

\item{censor_vector}{Vector \code{N x 1} of the indicator vector of censored responses.}

\item{dist}{Distribution of the random effects and random error. Available options are \code{Normal}, \code{Student} and \code{Slash}.}

\item{struc}{Structure of the correlation structure. Available options are \code{UNC}, \code{DEC}, \code{CAR}.}

\item{direction}{Direction of censoring type. Available options are \code{left} and \code{right}.}

\item{thin_num}{A positive integer specifying the period for saving samples. The default is 5. See more details in rstan::stan().}

\item{chains_num}{A positive integer specifying the number of chains generating by rstan::stan(). The default is 3.}

\item{iter_num}{A positive integer specifying the number of iterations for each chain (including warmup). The default is 5000.}

\item{burn_percen}{A percentage of the warm-up iterations in each chain the Stan. The default is 0.2.}

\item{seed_set}{A random seed. The default is NULL.}

\item{adapt_delta_set}{A parameter to control the sampler's behavior. The default is 0.8. See rstan::stan() for more details.}
}
\value{
Return a S4 class SMNlmecfit object. Using function \code{SMNlmec.summary()} to obtain the estimation of parameters and model selection criteria. The SMNlmecfit include:
\item{stan_object}{A stanfit object from rstan::stan().}
\item{model_criteria}{A list includes LPML, DIC, EAIC, EBIC, K-L divergence.}
\item{dist_set}{The setting of distribution of the stan model.}
\item{struc_set}{The setting of correlation structure of the stan model.}
}
\description{
This function fits left, right censored mixed-effects linear model, with scale mixture of normal distribution errors, using the Stan. It returns estimates, standard errors and LPML, AIC, BIC and DIC.
}
\examples{
\donttest{
require(rstan)
require(StanHeaders)
require(MASS)
require(tmvtnorm)
require(mvtnorm)
require(mnormt)

data("UTIdata_sub")
data1 <- UTIdata_sub
y1 <- c(log10(data1$RNA))
cc <- (data1$RNAcens==1)+0
y_com<-as.numeric(y1)
rho_com<-as.numeric(cc)
x <- cbind(
 (data1$Fup==0)+0,
 (data1$Fup==1)+0,
 (data1$Fup==3)+0,
 (data1$Fup==6)+0,
 (data1$Fup==9)+0,
 (data1$Fup==12)+0,
 (data1$Fup==18)+0,
 (data1$Fup==24)+0
 )
z <- matrix(rep(1, length(y1)), ncol=1)

UTI_T_DEC <- SMNlmec.est(ID = data1$Patid, x_set = x, z_set = z,
                         tt = data1$Fup, y_complete = y_com,
                         censor_vector = rho_com, dist = "Student",
                         struc = "DEC", direction = "left",
                         thin_num = 1, chains_num = 1, iter_num = 3000,
                         burn_percen = 0.1, seed_set = 9955,
                         adapt_delta_set = 0.8)

SMNlmec.summary(UTI_T_DEC)
}

}
\references{
Kelin Zhong, Fernanda L. Schumacher, Luis M. Castro and Victor H. Lachos. Bayesian analysis of censored linear mixed-effects models for heavy-tailed  irregularly observed repeated measures. Statistics in Medicine, 2025. doi:10.1002/sim.10295
}
