\name{hclustcompro_detail_resampling}
\alias{hclustcompro_detail_resampling}
\title{
Resampling process in detail (one curve by set of clone).}
\description{
Based on a resampling process, we generate clone and we check the CorCrit_alpha. The function shows each set of clone curves.}
\usage{
hclustcompro_detail_resampling(D1, D2 = NULL, acc = 2, method = "ward.D2", iter = 5)
}
\arguments{
  \item{D1}{
    First dissimilarity matrix or contingency table (square matrix). \cr You can replace D1 by a hclustcompro object (Don't use D2 in this case).
  }
  \item{D2}{
    Second dissimilarity matrix or network data (square matrix) same size than D1. \cr If D1 is a hclustcompro object D2 is set to NULL.
  }
  \item{acc}{
    Number of digits after the comma for the alpha value.
  }
  \item{method}{
    The agglomeration method to be used. This should be (an unambiguous abbreviation of) one of "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).
  }
    \item{iter}{
    The number of clones cheked for each observation.
  }
}
\details{
\strong{Definition of the criterion:}\cr\cr

A criterion for choosing alpha IN [0;1] must be determined by balancing the weights between the two information sources in the final classification. To obtain alpha, we define the following criterion:
\deqn{CorCrit_alpha = |Cor(dist_cophenetic,D1) - Cor(dist_cophenetic,D2)|}  \deqn{equation (1)}
The CorCrit_alpha criterium in (1) represents the difference in absolute value between two cophenetic correlation (Cophenetic correlation is defined as the correlation between two distances matrices. It is calculated by considering the half distances matrices as vectors. It measures of how faithfully a dendrogram preserves the pairwise distances between the original unmodeled data points). The first correlation is associated with the comparison between D1 and ultrametric distances from the HAC with alpha fixed; while the second compares D2 and ultrametric distances from the HAC with alpha fixed. Then, in order to compromise between the information provided by D1 and D2, we decided to estimate alpha with hat(alpha) such that:
\deqn{hat(alpha) = min CorCrit_alpha}
\deqn{equation (2)}

\strong{Resampling strategy:}\cr\cr

To do this, a set of "clones" is created for each observation i. A clone c of observation i is a copy of observation i for which the adjacency relationships to others have been modified. The clone has none conection exept with j. A set is generated by varying j for all observations except i.
A HAC is then carried out using the combination defined in (1) with D1(c) a (n+1)X(n+1) matrix where the observations i and c are identical and D2(c) a (n+1)X(n+1) matrix where the clone c of i has different neighbourhood relationships from those of i. We can create a set of n-1 clones for each element i in n, so n(n-1) clones in total.

Intuitively, by varying alpha between 0 and 1, we will be able to identify when the clone and the initial observation will be separated on the dendrogram. This moment will correspond to the value of alpha above which the weight given to information on the connection between observations contained in D2 has too much impact on the results compared to that of D1.

Let CorCrit_alpha(c) defines the same criterion as in (1) in which D1 ans D2 are replaced respectively by D1(c) and D2(c).
The estimated alpha is the average of estimated values for each clone.\cr
For each clone (c):
\deqn{hat(alpha)(c) = min   CorCrit_alpha(c)}
\deqn{equation (3)}
hat(alpha)^* is the average of the hat(alpha)(c). In the same spirit as confidence intervals based on bootstrap percentiles (Efron & Tibshirani, 1993), a percentile confidence interval based on replication is also be obtained using the empirical percentiles of the distribution of hat(alpha)(c).
\deqn{hat(alpha)* = (1 / n(n-1) ) * sum{ hat(alpha)(c) }}
\deqn{equation (4)}
\deqn{c IN [1 ; n(n-1)].}

}

\value{
  \item{plot }{The interactive plot: CorCrit_alpha criterium for each resampling dataset}
}

\author{
A. COULON

L. BELLANGER

P. HUSI
}

\examples{
###################################
#      For view the equation      #
###################################

plot(
  c(.6,.6,.6,.6),
  c(.9,.5,-.3,-.7),
  xlim = c(.6,1.4),
  ylim = c(-1.1,1),
  axes = FALSE,
  main = "Equations:",
  xlab = "",
  ylab = "",
  pch = 1
)
text(.65, .9, "( 1 )")
text(.65, .5, "( 2 )")
text(.65,-.3, "( 3 )")
text(.65,-.7, "( 4 )")

text(1, .9,
  expression(CorCrit[alpha] ==  abs(Cor(dist[cophenetic],dist[ceramic]) - Cor(dist[cophenetic],
  dist[stratigraphic])
)))
text(1, .5, expression(hat(alpha) == min(CorCrit[alpha], alpha)))

text(1,-.3, expression(hat(alpha)^(c) == min(CorCrit[alpha]^(c), alpha)))
text(1,-.7, expression(hat(alpha)^"*" == frac(1,n(n-1)) * sum(hat(alpha)^(c),c==1,n(n-1))))

#################################


##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.
#library(SPARTAAS)
#data(datangkor)

#network stratigraphic data (Network)
#network <- datangkor$stratigraphy

#contingency table
#cont <- datangkor$contingency

\donttest{
#hclustcompro_detail_resampling(D1 = CAdist(cont, nPC="max"), D2 = adjacency(network))
}


}
