% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotModelOptim.R
\name{spotModelOptim}
\alias{spotModelOptim}
\title{Optimize predicted meta model
 
Optimizes an existing fit of a model to get an optimal new design point. 
Executed after building the prediction model in the sequential SPOT step.}
\usage{
spotModelOptim(startPoint, spotConfig)
}
\arguments{
\item{startPoint}{initial points for the optimization}

\item{spotConfig}{list of all options, needed to provide data for calling functions.

This function uses the parameter \code{spotConfig$seq.modelFit}. This is supposed to be a fit, that can be evaluated by the associated \code{spotConfig$seq.predictionModel.func} function.
The parameter \code{spotConfig$seq.predictionOpt.method} will be used to choose the optimization method to be used to find the minimum of the fitted model:\cr
"optim-L-BFGS-B" - BFGS quasi-Newton: \code{stats} Package\cr
"pso" - Particle Swarm Optimization: \code{pso} Package \cr
"cmaes" - Covariance Matrix Adaptation Evolution Strategy: \code{cmaes} Package\cr
"genoud" - Combines evolutionary search algorithms with derivative-based (Newton or quasi-Newton) methods: \code{rgenoud} Package\cr
"DEoptim" - Differential Evolution implementation: \code{DEoptim} Package\cr
"bobyqa" - Trust region method that forms quadratic models by interpolation: \code{minqa} Package\cr
"BBoptim" - Strategy using different Barzilai-Borwein step-lengths: \code{BB} Package\cr
"GenSA" - Generalized simulated annealing which for global minimization of a very complex non-linear objective function with a very large number of optima: \code{GenSA} Package\cr
"hjkb" - Bounded Hooke-Jeeves algorithm for derivative-free optimization: \code{dfoptim} Package\cr\cr
Additionally to the above methods, several methods from the package \code{nloptr} can be chosen. For instance:\cr
"NLOPT_LN_NELDERMEAD" - Nelder-Mead Simplex\cr
"NLOPT_LN_SBPLX" - Nelder-Mead Simplex on sequence of subspaces\cr
"NLOPT_GN_DIRECT"  - Direct Search \cr
"NLOPT_GN_DIRECT_L"  - Direct Search, locally biased\cr\cr
The complete list of suitable nlopt methods (non-gradient, bound constraints) is: \cr
"NLOPT_GN_DIRECT","NLOPT_GN_DIRECT_L","NLOPT_GN_DIRECT_L_RAND",
"NLOPT_GN_DIRECT_NOSCAL","NLOPT_GN_DIRECT_L_NOSCAL","NLOPT_GN_DIRECT_L_RAND_NOSCAL",
"NLOPT_GN_ORIG_DIRECT","NLOPT_GN_ORIG_DIRECT_L","NLOPT_LN_PRAXIS",                            
"NLOPT_GN_CRS2_LM","NLOPT_LN_COBYLA","NLOPT_LN_NEWUOA_BOUND",
"NLOPT_LN_NELDERMEAD","NLOPT_LN_SBPLX","NLOPT_LN_BOBYQA","NLOPT_GN_ISRES"\cr\cr
All of the above methods use bound constraints, which will be chosen with the limits specified in \code{spotConfig$alg.roi} (or the \code{.roi} file).
For references and details on the specific methods, please check the documentation of the packages that provide them.

Note that some methods may require additional parametrization. For this purpose, it would be recommended to use \code{spotPredictOptMulti}
as a template to write custom functions. \code{spotPredictOptMulti} itself is limited to calling mostly default settings of a large number of different optimizers available in \code{R}.}
}
\value{
returns the list \code{spotConfig} with two new entries:\cr
	\code{spotConfig$optDesign} are the parameters of the new minimal design point \cr
\code{spotConfig$optDesignY} is the associated value of the objective function
}
\description{
Optimize predicted meta model
 
Optimizes an existing fit of a model to get an optimal new design point. 
Executed after building the prediction model in the sequential SPOT step.
}
\seealso{
\code{\link{spotModelParetoOptim}} solves the same task for multi-criteria optimization (i.e. more than just one surrogate model)\cr
}

