% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildEnsembleStack.R
\name{buildEnsembleStack}
\alias{buildEnsembleStack}
\title{Ensemble: Stacking}
\usage{
buildEnsembleStack(x, y, control = list())
}
\arguments{
\item{x}{design matrix (sample locations), rows for each sample, columns for each variable.}

\item{y}{vector of observations at \code{x}}

\item{control}{(list), with the options for the model building procedure:\cr
\code{modelL1} Function for fitting the L1 model (default: \code{buildLM}) which combines the results of the L0 models. \cr
\code{modelL1Control} List of control parameters for the L1 model (default: \code{list()}).\cr
\code{modelL0} A list of functions for fitting the L0 models (default: \code{list(buildLM,buildRandomForest,buildKriging)}). \cr
\code{modelL0Control} List of control lists for each L0 model (default: \code{list(list(),list(),list())}).\cr}
}
\value{
returns an object of class \code{ensembleStack}.
}
\description{
Generates an ensemble of surrogate models with stacking (stacked generalization).
}
\note{
Loosely based on the code by Emanuele Olivetti https://github.com/emanuele/kaggle_pbr/blob/master/blend.py
}
\examples{
\donttest{
## Create design points
x <- cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points
y <- funBranin(x)
## Create model with default settings
fit <- buildEnsembleStack(x,y)
## Predict new point
predict(fit,cbind(1,2))
## True value at location
funBranin(matrix( c(1,2), 1))
}
}
\references{
Bartz-Beielstein, Thomas. Stacked Generalization of Surrogate Models-A Practical Approach. Technical Report 5/2016, TH Koeln, Koeln, 2016.

David H Wolpert. Stacked generalization. Neural Networks, 5(2):241-259, January 1992.
}
\seealso{
\code{\link{predict.ensembleStack}}
}
