% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildGaussianProcessModel.R
\name{buildGaussianProcess}
\alias{buildGaussianProcess}
\title{Gaussian Process Model Interface}
\usage{
buildGaussianProcess(x, y, control = list())
}
\arguments{
\item{x}{matrix of input parameters. Rows for each point, columns for each parameter.}

\item{y}{one column matrix of observations to be modeled.}

\item{control}{list of control parameters. \code{n} subset size.}
}
\value{
an object of class \code{"spotGaussianProcessModel"}, 
with a \code{predict} method and a \code{print} method.
}
\description{
Gaussian Process Model Interface
}
\examples{
N <- 200
x <- matrix( seq(from=-1, to = 1, length.out = N), ncol = 1)
y <- funSphere(x)  + rnorm(N, 0, 0.1)
fit <- buildGaussianProcess(x,y)
## Print model parameters
print(fit)
## Predict at new location
xNew <- matrix( c(-0.1, 0.1), ncol = 1)
predict(fit, xNew)
## True value at location
t(funSphere(xNew))
}
