% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasGeneric.R
\name{getGenericTrainValTestData}
\alias{getGenericTrainValTestData}
\title{getGenericTrainValTestData}
\usage{
getGenericTrainValTestData(dfGeneric = NULL, prop = 0.5)
}
\arguments{
\item{dfGeneric}{data, e.g.,  obtained with \code{\link{getDataCensus}}. Default: \code{NULL}.}

\item{prop}{vector. proportion between train / test and train/val. Default: \code{2/3}. If one
value is given, the same proportion will be used for both split. Otherwise, the first
entry is used for the test/training split and the second value for the training/validation
split. If the second value is 1, the validation set is empty.
Given \code{prop = (p1,p2)}, the data will be partitioned as shown in the following two steps:
 \describe{
    \item{Step 1:}{\code{train1 = p1*data} and \code{test = )(1-p1)*data}}
    \item{Step 2:}{\code{train2 = p2*train1 = p2*p1*data} and \code{val = )(1-p2)*train1 = (1-p2)*p1*data}}
     }}
}
\value{
list with training, validation and test data: trainCensus, valCensus, testCensus.
}
\description{
getGenericTrainValTestData
}
\note{
If \code{p2=1}, no validation data will be generated.
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE = FALSE
if(PYTHON_RETICULATE){
task.type <- "classif"
nobs <- 1e4
nfactors <- "high"
nnumericals <- "high"
cardinality <- "high"
data.seed <- 1
cachedir <- "oml.cache"
target = "age"
prop <- 2 / 3
dfCensus <- getDataCensus(task.type = task.type,
nobs = nobs, nfactors = nfactors,
nnumericals = nnumericals, cardinality = cardinality,
data.seed = data.seed, cachedir = cachedir,
target = target)
census <- getGenericTrainValTestData(dfGeneric=dfCensus,
prop = prop)
## train data size is 2/3*2/3*10000:
dim(census$trainGeneric)
}
}
}
\seealso{
\code{\link{getKerasConf}}

\code{\link{funKerasGeneric}}

\code{\link{getDataCensus}}
}
