% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasMnist.R
\name{evalKerasMnist}
\alias{evalKerasMnist}
\title{evalKerasMnist}
\usage{
evalKerasMnist(x, kerasConf, data)
}
\arguments{
\item{x}{matrix of hyperparameter values to evaluate with the function.
Rows for points and columns for dimension.}

\item{kerasConf}{List of additional parameters passed to keras as described in \code{\link{getKerasConf}}.
Default: \code{kerasConf = getKerasConf()}.}

\item{data}{mnist data set. Default: \code{\link{getMnistData}}.}
}
\value{
list with function values (training, validation, and test loss/accuracy,
and keras model information)
}
\description{
Hyperparameter Tuning: Keras MNIST Classification Test Function.
}
\details{
Trains a simple deep NN on the MNIST dataset.
Standard Code from https://keras.rstudio.com/
Modified by T. Bartz-Beielstein (tbb@bartzundbartz.de)
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE <- FALSE
if(PYTHON_RETICULATE){

library("SPOTMisc")
kerasConf <- getKerasConf()
kerasConf$verbose <- 1
kerasConf$model <- "dl"
cfg <-  getModelConf(kerasConf)
x <- matrix(cfg$default, nrow=1)
if (length(cfg$transformations) > 0) {  x <- transformX(xNat=x, fn=cfg$transformations)}
res <- evalKerasMnist(x, kerasConf, data = getMnistData(kerasConf))
#
kerasConf$model <- "cnn"
kerasConf$encoding <- "tensor"
cfg <-  getModelConf(kerasConf)
x <- matrix(cfg$default, nrow=1)
if (length(cfg$transformations) > 0) {  x <- transformX(xNat=x, fn=cfg$transformations)}
res <- evalKerasMnist(x, kerasConf, data = getMnistData(kerasConf))
}
}
}
\seealso{
\code{\link{getKerasConf}}

\code{\link{funKerasMnist}}

\code{\link[keras]{fit}}
}
