% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasCensus.R
\name{predDlCensus}
\alias{predDlCensus}
\title{Predict deep learning models on Census data}
\usage{
predDlCensus(
  x = NULL,
  target = "age",
  task.type = "classif",
  nobs = 10000,
  nfactors = "high",
  nnumericals = "high",
  cardinality = "high",
  cachedir = "oml.cache",
  k = 1,
  prop = 2/3,
  batch_size = 32,
  verbosity = 0
)
}
\arguments{
\item{x}{matrix with untransformed hyperparameters, e.g., result from \code{\link[SPOT]{spot}}.
Hyperparameters will be transformed in predDlCensus with \code{\link[SPOT]{transformX}}
and transformations defined in \code{\link{getModelConf}}.}

\item{target}{target}

\item{task.type}{class/reg}

\item{nobs}{number of obsvervations, max: 229,285}

\item{nfactors}{(character) number of factor variables}

\item{nnumericals}{(character) number of numerical variables}

\item{cardinality}{(character) cardinality}

\item{cachedir}{cache directory}

\item{k}{number of repeats}

\item{prop}{vector. proportion between train / test and train/val. Default: \code{2/3}. If one
value is given, the same proportion will be used for both splits. Otherwise, the first
entry is used for the test/training split and the second value for the training/validation
split. If the second value is 1, the validation set is empty.
Given \code{prop = (p1,p2)}, the data will be partitioned as shown in the following two steps:
 \describe{
    \item{Step 1:}{\code{train1 = p1*data} and \code{test = )(1-p1)*data}}
    \item{Step 2:}{\code{train2 = p2*train1 = p2*p1*data} and \code{val = )(1-p2)*train1 = (1-p2)*p1*data}}
     }
Note: If \code{p2=1}, no validation data will be generated.}

\item{batch_size}{batch_size. Default: \code{32}.}

\item{verbosity}{verbosity. Default: 0}
}
\value{
list of matrices with true and predicted values.
\describe{
\item{\code{trueY}}{true values}
\item{\code{hatY}}{predicted values}
}
}
\description{
Predict deep learning models on Census data
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE <- FALSE
if(PYTHON_RETICULATE){
cfg <- getModelConf(list(model="dl"))
x <- matrix(cfg$defaults, nrow=1)
res <- predDlCensus(x=x, k=2)
}
}
}
