% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasCensus.R
\name{prepareComparisonPlot}
\alias{prepareComparisonPlot}
\title{prepare data frame for comparisons (boxplots, violin plots)}
\usage{
prepareComparisonPlot(
  runNrMl,
  runNrDl,
  directory,
  defaultModelList = list("dl", "cvglmnet", "kknn", "ranger", "rpart", "svm", "xgboost"),
  tunedModelList = list("dl", "cvglmnet", "kknn", "ranger", "rpart", "svm", "xgboost")
)
}
\arguments{
\item{runNrMl}{run number (character) of ml models}

\item{runNrDl}{run number (character) of dl models}

\item{directory}{location of the (non-default, e.g., tuned) parameter file}

\item{defaultModelList}{default model list. Default: \code{list("dl", "cvglmnet", "kknn",
"ranger", "rpart" ,  "svm", "xgboost")}}

\item{tunedModelList}{tuned model list. Default: \code{list("dl", "cvglmnet", "kknn",
"ranger", "rpart" ,  "svm", "xgboost")}}
}
\value{
data frame with results:
\describe{
	\item{\code{x}}{integer representing step}
	\item{\code{y}}{corresponding function value at step x.}
	\item{\code{name}}{ml/dl model name, e.g., ranger}
	\item{\code{size}}{initial design size.}
	\item{\code{yInitMin}}{min y value before SMBO is started, based on the
	initial design only.}
}
}
\description{
converts \code{result} from a \code{\link[SPOT]{spot}} run
into the long format for ggplot.
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE <- FALSE
if(PYTHON_RETICULATE){
runNrMl <- list("15")
runNrDl <- list("28")
directory <- "../book/data"
prepareComparisonPlot(runNrMl,
                    runNrDl,
                    directory)
}
}
}
