% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMCMCtrrace.R
\name{plotMCMCtrace}
\alias{plotMCMCtrace}
\title{plot MCMC trace plots}
\usage{
plotMCMCtrace(
  object,
  target = c("loglik", "PDF", "CDF", "QF"),
  X = NULL,
  Y = NULL,
  tau = 0.5,
  window = NULL
)
}
\arguments{
\item{object}{An object of class \code{SPQR}.}

\item{target}{A character indicating the statistic/estimate for which traceplot should be plotted;
\code{"loglik"}: log-likelihood (default), \code{"PDF"}: probability density function, \code{"CDF"}: cumulative density function,
\code{"QF"}: quantile function.}

\item{X}{If \code{target != "loglik"}, a row vector specifying the covariate values for which the estimates are computed. Default: \code{NULL}.}

\item{Y}{If \code{target = "PDF"} or \code{target = "CDF"} a scalar specifying the response value for which the estimates are computed. Default: \code{NULL}.}

\item{tau}{If \code{target != "QF"}, a scalar specifying the quantile level for which the estimates are computed. Default: 0.5.}

\item{window}{A vector specifying the range of index of the MCMC samples for which the traceplot should be plotted. Default is \code{NULL}
indicating that the whole chain is plotted.}
}
\value{
A \code{ggplot} object.
}
\description{
Show trace plot of the log-likelihood or estimates, of a \code{"SPQR"} class object fitted using the MCMC method
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)

## trace plot for log-likelihood
plotMCMCtrace(fit, target = "loglik")
}

}
