% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.SPQR.R
\name{print.summary.SPQR}
\alias{print.summary.SPQR}
\title{print method for \code{"summary.SPQR"}}
\usage{
\method{print}{summary.SPQR}(x, showModel = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{summary.SPQR}}

\item{showModel}{If \code{TRUE}, prints the detailed NN architecture by layer.}

\item{...}{Other arguments.}
}
\value{
No return value, called for side effects.
}
\description{
Print the output produced by summary.SPQR().
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)

## summarize output
summary(fit)
}
}
