% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\docType{methods}
\name{varTransform,msi.dataset-method}
\alias{varTransform,msi.dataset-method}
\alias{varTransform}
\title{Variance stabilizing transformation.}
\usage{
\S4method{varTransform}{msi.dataset}(object, method = "log")
}
\arguments{
\item{object}{\link{msi.dataset-class} object. See \link{msiDataset}.}

\item{method}{string (default = \code{log}). Transformation method.
Valid values are:
\itemize{
  \item "log": log-transformation defined as log(x + 1)
  \item "sqrt": square-root transformation.
}}
}
\value{
\link{msi.dataset-class} object with transformed peaks intensities.
}
\description{
\code{varTransform} transforms the MS intensities in order to reduce heteroscedasticity.
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2] * 20), sz[1]*sz[2], 20)
x[x < 0] <- 0 # MS data is positive
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Normalize and log-transform
msiX <- normIntensity(msiX, "median")
msiX <- varTransform(msiX, "log")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2]), sz[1]*sz[2], 20)
x[x < 0] <- 0 # MS data is positive
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Normalize using PQN
msiX <- normIntensity(msiX, "PQN")
}
