% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRTcount.R
\name{srtsim_count}
\alias{srtsim_count}
\title{Generate Data with Estimated Parameters}
\usage{
srtsim_count(
  simsrt,
  breaktie = "random",
  total_count_new = NULL,
  total_count_old = NULL,
  rrr = NULL,
  nn_num = 5,
  nn_func = c("mean", "median", "ransam"),
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{simsrt}{A object with estimated parameters from fitting step}

\item{breaktie}{A character string specifying how ties are treated.  Same as the "tie.method" in rank function}

\item{total_count_new}{The (expected) total number of reads or UMIs in the simulated count matrix.}

\item{total_count_old}{The total number of reads or UMIs in the original count matrix.}

\item{rrr}{The ratio applies to the gene-specific mean estimate, used for the fixing average sequencing depth simulation. Default is null. Its specification will override the specification of total_count_new and total_count_old.}

\item{nn_num}{A integer of nearest neighbors, default is 5.}

\item{nn_func}{A character string specifying how the psedo-count to be generated. options include 'mean','median' and 'ransam'.}

\item{numCores}{The number of cores to use}

\item{verbose}{Whether to show running information for srtsim_count}
}
\value{
Returns a SRTsim object with a newly generated count matrix
}
\description{
Generate Data with Estimated Parameters
}
\examples{

## Create a simSRT object
toySRT  <- createSRT(count_in=toyData$toyCount,loc_in = toyData$toyInfo)
set.seed(1)
## Estimate model parameters for data generation
toySRT <- srtsim_fit(toySRT,sim_schem="tissue")
## Generate synthetic data with estimated parameters
toySRT <- srtsim_count(toySRT)

## Explore the synthetic count matrix
simCounts(toySRT)[1:3,1:3]
}
