% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchiesAndFormula2ModelMatrix.R
\name{HierarchiesAndFormula2ModelMatrix}
\alias{HierarchiesAndFormula2ModelMatrix}
\title{Model matrix representing crossed hierarchies according to a formula}
\usage{
HierarchiesAndFormula2ModelMatrix(
  data,
  hierarchies,
  formula,
  inputInOutput = TRUE,
  makeColNames = TRUE,
  crossTable = FALSE,
  total = "Total",
  simplify = TRUE,
  hierarchyVarNames = c(mapsFrom = "mapsFrom", mapsTo = "mapsTo", sign = "sign", level
    = "level"),
  unionComplement = FALSE,
  reOrder = TRUE,
  sep = "-"
)
}
\arguments{
\item{data}{Matrix or data frame with data containing codes of relevant variables}

\item{hierarchies}{List of hierarchies, which can be converted by \code{\link{AutoHierarchies}}.
Thus, the variables can also be coded by \code{"rowFactor"} or \code{""}, which correspond to using the categories in the data.}

\item{formula}{A model formula}

\item{inputInOutput}{Logical vector (possibly recycled) for each element of hierarchies.
TRUE means that codes from input are included in output. Values corresponding to \code{"rowFactor"} or \code{""} are ignored.}

\item{makeColNames}{Colnames included when TRUE (default).}

\item{crossTable}{Cross table in output when TRUE}

\item{total}{Vector of total codes (possibly recycled) used when running \code{\link{Hrc2DimList}}}

\item{simplify}{When TRUE (default) the model can be simplified when total codes are found in the hierarchies (see examples).}

\item{hierarchyVarNames}{Variable names in the hierarchy tables as in \code{\link{HierarchyFix}}}

\item{unionComplement}{Logical vector (possibly recycled) for each element of hierarchies.
When TRUE, sign means union and complement instead of addition or subtraction.
Values corresponding to \code{"rowFactor"} and \code{"colFactor"} are ignored.}

\item{reOrder}{When TRUE (default) output codes are ordered in a way similar to a usual model matrix ordering.}

\item{sep}{String to separate when creating column names}
}
\value{
A sparse model matrix or a list of two elements (model matrix and cross table)
}
\description{
How to cross the hierarchies are defined by a formula. The formula is automatically simplified when totals are involved.
}
\examples{
# Create some input
z <- SSBtoolsData("sprt_emp_withEU")
ageHier <- SSBtoolsData("sprt_emp_ageHier")
geoDimList <- FindDimLists(z[, c("geo", "eu")], total = "Europe")[[1]]

# Shorter function name
H <- HierarchiesAndFormula2ModelMatrix

# Small dataset example. Two dimensions.
s <- z[z$geo == "Spain", ]
geoYear <- list(geo = geoDimList, year = "")
m <- H(s, geoYear, ~geo * year, inputInOutput = c(FALSE, TRUE))
print(m, col.names = TRUE)
attr(m, "total")     # Total code 'Europe' is found
attr(m, "startCol")  # Two model terms needed

# Another model and with crossTable in output
H(s, geoYear, ~geo + year, crossTable = TRUE)

# Three dimensions
ageGeoYear <- list(age = ageHier, geo = geoDimList, year = "allYears")
m <- H(z, ageGeoYear, ~age * geo + geo * year)
head(colnames(m))
attr(m, "total")
attr(m, "startCol")

# With simplify = FALSE
m <- H(z, ageGeoYear, ~age * geo + geo * year, simplify = FALSE)
head(colnames(m))
attr(m, "total")
attr(m, "startCol")

# Compute aggregates
m <- H(z, ageGeoYear, ~geo * age, inputInOutput = c(TRUE, FALSE, TRUE))
t(m) \%*\% z$ths_per

# Without hierarchies. Only factors.
ageGeoYearFactor <- list(age = "", geo = "", year = "")
t(H(z, ageGeoYearFactor, ~geo * age + year:geo))
}
\seealso{
\code{\link{Hierarchies2ModelMatrix}}, \code{\link{Formula2ModelMatrix}}.
}
\author{
Øyvind Langsrud
}
