% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_weighted.R
\name{quantile_weighted}
\alias{quantile_weighted}
\title{Weighted quantiles}
\usage{
quantile_weighted(
  x,
  probs = (0:4)/4,
  weights = rep(1, length(x)),
  type = 2,
  eps = 1e-09
)
}
\arguments{
\item{x}{Numeric vector}

\item{probs}{Numeric vector of probabilities}

\item{weights}{Numeric vector of weights of the same length as \code{x}}

\item{type}{An integer, \code{2} (default) or \code{5}. Similar to types 2 and 5 in \code{\link{quantile}}.}

\item{eps}{Precision parameter used when \code{type=2} so that numerical inaccuracy is accepted (see details)}
}
\value{
Quantiles as a named numeric vector.
}
\description{
The default method (\code{type=2}) corresponds to weighted percentiles in SAS.
}
\details{
When \code{type=2}, averaging is used in case of equal of probabilities.
Equal probabilities (\code{p[j]==probs[i]}) is determined by
\code{abs(1-p[j]/probs[i])<eps}
with \code{p=cumsum(w)/sum(w)}
where \code{w=weights[order(x)]}.
}
\note{
Type 2 similar to type 5 in \code{DescTools::Quantile}
}
\examples{
x <- rnorm(27)/5 + 1:27
w <- (1:27)/27

quantile_weighted(x, (0:5)/5, weights = w)
quantile_weighted(x, (0:5)/5, weights = w, type = 5)

quantile_weighted(x) - quantile(x, type = 2)
quantile_weighted(x, type = 5) - quantile(x, type = 5)

}
