# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title G_fun_cpp
#' @description Supporting function for gradient computation in \code{\link{SSDL}[CDL]}. 
#' @param x is a vector of length \eqn{2m}
#' @param y is a vector of length \eqn{2m}
#' @param W is a frequency matrix \eqn{m \times s}
#' @return a vector of length \eqn{s}
#' @keywords internal
#' @export
G_fun_cpp <- function(x, y, W) {
    .Call(`_SSDL_G_fun_cpp`, x, y, W)
}

#'@title Supporting function for the gradient computation.
#'@description The gradient computation using a parallel application of the function \code{\link{G_fun_cpp}} 
#'to a vector \code{y}, which is defined as a difference between a data sketch and 
#'the decomposition sketch, \emph{i.e.} \eqn{SK - SK(D\cdot A)}.
#'@seealso \code{\link{Gradient_D_cpp_parallel}}
#'@param S is a matrix
#'@param y is a vector
#'@param W is a frequency matrix
#'@return a gradient stored in the matrix \code{S}.
#'@keywords internal
#'@export
gradient <- function(S, y, W) {
    .Call(`_SSDL_gradient`, S, y, W)
}

#' @title Rowsums_cpp
#'@description Implementation of a matrix rows' summation and a sketch vector subtraction
#'@details The sums over the rows of the matrix \eqn{P \in R^{2m \time n}} is a sketch of the decomposition, 
#'\emph{i.e.} \eqn{SK(D\cdot A)}. It is defined as \eqn{P = [cos(W\cdot D \cdot A);sin(W\cdot D \cdot A)]}, where \eqn{W} is a frequency matrix, \eqn{D} is 
#'a dictionary and \eqn{A} is a code matrix. This function computes a vector of the difference between a 
#'data sketch and the decomposition sketch: \eqn{SK - SK(D\cdot A)}. 
#'@seealso \code{\link{Gradient_D_cpp_parallel}} 
#'@param P is a matrix
#'@param SK is a data sketch
#'@return a vector of length \eqn{2m}
#'@keywords internal
#'@export
Rowsums_cpp <- function(P, SK) {
    .Call(`_SSDL_Rowsums_cpp`, P, SK)
}

#'@title Rowsums_cpp_parallel
#'@description Parallel implementation of a matrix rows' summation and a sketch vector subtraction
#'@param P is a matrix
#'@param SK is a data sketch
#'@return a vector of matrix row sums minus a data sketch
#'@seealso \code{\link[SSDL]{Rowsums_cpp}}
#'@keywords internal
#'@export
Rowsums_cpp_parallel <- function(P, SK) {
    .Call(`_SSDL_Rowsums_cpp_parallel`, P, SK)
}

#'@title Sparse matrix product
#'@description Implementation of the product a matrix by a sparse matrix
#'
#'@param D is a matrix
#'@param Z is a sparse matrix
#'@return a product matrix
#'@keywords internal
#'@export
Sparse_prod <- function(D, Z) {
    .Call(`_SSDL_Sparse_prod`, D, Z)
}

#' @title Sparse product by rows
#'@description Implementation sparse matrix product by rows
#'
#'@param D is a matrix
#'@param Z is a matrix
#'@param CosSin indicates whether to compute cos and sin of the resulting matrix
#'@return a matrix
#'@keywords internal
#'@export
Sparse_prod_row <- function(D, Z, CosSin = FALSE) {
    .Call(`_SSDL_Sparse_prod_row`, D, Z, CosSin)
}

#'@title Sparse matrix product
#'@description Parallel computation of a product of a matrix by a sparse matrix
#'@param D is a matrix
#'@param Z is a matrix
#'@return a product matrix
#'@keywords internal
#'@export
Sparse_prod_parallel <- function(D, Z) {
    .Call(`_SSDL_Sparse_prod_parallel`, D, Z)
}

#'@title Gradient_D_cpp_parallel
#'@description Parallel computation of the gradient with respect to a dictionary matrix and
#' the objective function computation.  
#' @details The objective function is given as \eqn{\|SK - SK(D\cdot A)\|^2}, where \eqn{SK} is 
#' a data sketch, \eqn{A = \{\alpha_1, \dots, \alpha_n\}} is a code matrix and \eqn{SK(D\cdot A)} 
#' denotes a decomposition sketch, which is defined as: 
#' \eqn{SK(D\cdot A) = \frac{1}{n}\left[\sum_{i=1}^n \cos(W\cdot D \cdot \alpha_i), 
#' \sum_{i=1}^n \sin(W\cdot D \cdot \alpha_i)\right]}.
#' The gradient of this objective function with respect to a dictionary element \eqn{d_l \in R^{s}} is given as:
#' \eqn{- 2 \left( \nabla_{d_l} SK(D\cdot A) \right)^{\top} \cdot r},
#' where \eqn{r = SK - SK(D \cdot A)}, \eqn{\frac{\delta}{\delta d_l} SK^j(D\cdot A) = 1i \cdot \left( \frac{1}{n} 
#' \sum_{i = 1}^n  A_{li}\cdot \prod_{k=1}^K SK^j(A_{ki}\cdot d_k) \right)\cdot w_j^{\top}},
#' and \eqn{SK^j(\cdot )} is the \eqn{j^{th}} coordinate of the sketch vector.
#'@param D is a dictionary \eqn{s \times K}.
#'@param A is a code matrix \eqn{K \times n}.
#'@param W is a frequency matrix \eqn{m \times s} with frequency vectors in matrix rows.
#'@param SK is a data sketch. It is a \eqn{2m}-dimensional vector.
#'@param ComputeGrad indicates whether to compute the gradient or only the objective function value
#'@return a list
#'\itemize{
#'   \item \code{grad} is a computed gradient
#'   \item \code{ObjFun} is a objective function value
#'   \item \code{diff} is a vector of the difference between the data sketch and the decomposition sketch
#'} 
#'@examples
#' RcppParallel::setThreadOptions(numThreads = 2)
#' X = matrix(abs(rnorm(n = 1000)), ncol = 100, nrow = 10)
#' X_fbm = bigstatsr::as_FBM(X)$save()
#' W = chickn::GenerateFrequencies(Data = X_fbm, m = 64, N0 = ncol(X_fbm),
#'                                 ncores = 1, niter= 3, nblocks = 2, sigma_start = 0.001)$W
#' SK= chickn::Sketch(X_fbm, W)
#' D = X_fbm[, sample(ncol(X_fbm), 10)]
#' A = sapply(sample(ncol(X_fbm), 5), function(i){
#'     as.vector(glmnet::glmnet(x = D, y = X_fbm[,i],
#'               lambda = 0, intercept = FALSE, lower.limits = 0)$beta)})
#' G = Gradient_D_cpp_parallel(D, A, W, SK)$grad                                    
#'@export
Gradient_D_cpp_parallel <- function(D, A, W, SK, ComputeGrad = TRUE) {
    .Call(`_SSDL_Gradient_D_cpp_parallel`, D, A, W, SK, ComputeGrad)
}

#'@title Gradient D
#'@description Gradient with respect to dictionary using sparse product
#'@param D is a dictionary \eqn{s \times K}.
#'@param A is a code matrix \eqn{K \times n}.
#'@param W is a frequency matrix \eqn{m \times s} with frequency vectors in matrix rows.
#'@param SK is a data sketch. It is a \eqn{2m}-dimensional vector.
#'@return a gradient matrix
#'@keywords internal
#'@export
Gradient_D_cpp <- function(D, A, W, SK) {
    .Call(`_SSDL_Gradient_D_cpp`, D, A, W, SK)
}

#'@title COMP objective function  
#'@description Computation of the objective function from the Compressive Orthogonal Matching Pursuit algorithm.
#'@details The objective function of the Compressive Orthogonal Matching Pursuit is defined as:
#'\eqn{-\frac{SK(d)\cdot r}{\|SK(d)\|}}, where \eqn{SK(d)} denotes a 
#'sketch of the dictionary element \code{d} and \eqn{r} is the residue vector, which is defined as the difference between
#'the data sketch \eqn{SK} and the weighted sum of the dictionary elements' sketches, \emph{i.e.}
#'\eqn{SK - \sum_{i=1}^K \beta_i \cdot SK(d_i)}.
#'This function is involved in \code{\link{COMP_initialization}} routine. 
#'@inheritParams Gradient_D_cpp_parallel
#'@param d is a dictionary element 
#'@param residue is a residue vector.
#'@return an objective function value
#'@examples
#' X = matrix(abs(rnorm(n = 1000)), ncol = 100, nrow = 10)
#' X_fbm = bigstatsr::as_FBM(X)$save()
#' W = chickn::GenerateFrequencies(Data = X_fbm, m = 64, N0 = ncol(X_fbm),
#'                                 ncores = 1, niter= 3, nblocks = 2, sigma_start = 0.001)$W
#' SK= chickn::Sketch(X_fbm, W)
#' D = X_fbm[, sample(ncol(X_fbm), 10)]
#' weights = sample(10, 10)/10
#' SK_D = rbind(cos(W%*%D), sin(W%*%D))
#' d = D[,1]
#' r = SK - SK_D%*%weights
#' OF = ObjFun_COMP_cpp(d, W, r)
#' @export
#'@seealso \code{\link{COMP_initialization}}, \code{\link{Gradient_COMP_cpp}}
ObjFun_COMP_cpp <- function(d, W, residue) {
    .Call(`_SSDL_ObjFun_COMP_cpp`, d, W, residue)
}

#' @title COMP Gradient
#' @description The gradient of the objective function from the Compressive Orthogonal Matching Pursuit
#' with respect to a dictionary element. 
#' @details \code{Gradient_COMP_cpp} computes the gradient of the objective function 
#' \eqn{OF(d) = -\frac{SK(d)\cdot r}{\|SK(d)\|}}, where \eqn{SK(d)} denotes a 
#' sketch of the dictionary element \code{d} and \eqn{r} is the residue vector. 
#' The gradient is given as \eqn{\nabla_d OF(d) = \frac{-G(SK(d), y, W)}{\|SK(d)\|}}, where 
#' a vector \eqn{y  = r-\left(r^{\top} \cdot SK(d)\right)\cdot SK(d)} and 
#' a function \eqn{G(x, y, W)} is
#' given as: 
#' \eqn{G(x,y, W) = \left(x[1:m]\odot y[m+1:2m] - x[m+1]\odot y[1:m]\right)^{\top}\cdot W},
#' where \eqn{\odot} denotes an element-wise vector multiplication.   
#' @inheritParams ObjFun_COMP_cpp
#' @return a gradient vector
#' @examples
#' X = matrix(abs(rnorm(n = 1000)), ncol = 100, nrow = 10)
#' X_fbm = bigstatsr::as_FBM(X)$save()
#' W = chickn::GenerateFrequencies(Data = X_fbm, m = 64, N0 = ncol(X_fbm),
#'                                 ncores = 1, niter= 3, nblocks = 2, sigma_start = 0.001)$W
#' SK= chickn::Sketch(X_fbm, W)
#' D = X_fbm[, sample(ncol(X_fbm), 10)]
#' weights = sample(10, 10)/10
#' SK_D = rbind(cos(W%*%D), sin(W%*%D))
#' d = D[,1]
#' r = SK - SK_D%*%weights
#' Grad = Gradient_COMP_cpp(d, W, r)
#' @export
#' @seealso \code{\link{ObjFun_COMP_cpp}}, \code{\link{COMP_initialization}}
Gradient_COMP_cpp <- function(d, W, residue) {
    .Call(`_SSDL_Gradient_COMP_cpp`, d, W, residue)
}

