% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMP_initialization.R
\name{COMP_initialization}
\alias{COMP_initialization}
\title{COMP dictionary initialization}
\usage{
COMP_initialization(
  K,
  Data,
  SK_Data = NULL,
  Frequencies = NULL,
  lower = -Inf,
  upper = Inf,
  maxIter = 1500,
  HardThreshold = FALSE,
  print_level = 0,
  ncores = 1,
  m = nrow(Frequencies),
  ...
)
}
\arguments{
\item{K}{is a dictionary size.}

\item{Data}{is a Filebacked Big Matrix \eqn{s \times N} with data vectors stored in the matrix columns.}

\item{SK_Data}{is a data sketch. It is a \eqn{2m}-dimensional complex vector. The first \eqn{m} coordinates
correspond to the real parts and the last \eqn{m} coordinates to the imaginary parts.
If it is NULL, the sketch is computed using \code{Sketch} function of
\href{https://CRAN.R-project.org/package=chickn}{chickn} package.}

\item{Frequencies}{is a frequency matrix \eqn{m \times s} with frequency vectors in the matrix rows.
If NULL, the frequencies are generated using \code{GenerateFrequencies}
function of \href{https://CRAN.R-project.org/package=chickn}{chickn} package.}

\item{lower}{is a lower boundary. It is an \eqn{s}-dimensional vector.}

\item{upper}{is an upper boundary. It is an \eqn{s}-dimensional vector.}

\item{maxIter}{is a maximum number of iterations in the computation of new dictionary element.
The default value is 1500.}

\item{HardThreshold}{indicates whether to execute the hard thresholding step. The default is FALSE.}

\item{print_level}{controls how much output is shown during the optimization process. Possible values:
\itemize{
\item 0 no output (default value)
\item 1 show iteration number and value of objective function
\item 2 1 + show values of weights}}

\item{ncores}{is a number of cores. The default value is 1.}

\item{m}{is a number of the frequency vectors.}

\item{...}{are additional parameters passed to \link[chickn]{GenerateFrequencies} function.}
}
\value{
a list
\itemize{
\item \code{D} is the obtained dictionary,
\item \code{weights} is the resulting weights,
\item \code{ObjF} is the objective function values computed at each iteration.
\item \code{Sketch} is the data sketch
\item \code{Frequencies} is the frequency matrix}
}
\description{
Dictionary initialization using the Compressive Orthogonal Matching Pursuit (COMP) method
}
\details{
The initialization routine is based on the Compressive Orthogonal Matching Pursuit
(COMP) algorithm.
COMP is an iterative greedy method that builds a dictionary operating on a
compressed data version (a.k.a. data sketch).
It alternates between expanding the dictionary \eqn{D} with a new element \eqn{d_i},
whose sketch \eqn{SK(d_i)} is the most correlated to the residue, and
calculating the weights of the dictionary elements \eqn{w_1, \dots, w_K}
by minimizing the difference between the data sketch \eqn{SK(Data)} and a linear combination
of dictionary sketches, \emph{i.e.} \eqn{\|SK(Data) - \sum_{i=1}^K w_i \cdot SK(d_i)\|}.
Unlike COMP, the implemented dictionary initialization routine does not perform an additional global
optimization with respects to both variables: weights and dictionary elements.
}
\note{
COMP method has been presented in \insertRef{DBLP:journals/corr/KerivenTTG16}{SSDL}
}
\examples{
X = matrix(abs(rnorm(n = 1000)), ncol = 100, nrow = 10)
lb = apply(X, 1, min)
ub = apply(X, 1, max)
X_fbm = bigstatsr::FBM(init = X, ncol = ncol(X), nrow = nrow(X))
m = 64
W = chickn::GenerateFrequencies(Data = X_fbm, m = m, N0 = ncol(X_fbm),
                                ncores = 1, niter= 3, nblocks = 2, sigma_start = 0.001)$W
SK= chickn::Sketch(X_fbm, W)
D0 = COMP_initialization(K = 10, Data = X_fbm, SK_Data = SK, Frequencies = W,
                        lower = lb, upper = ub)$Dictionary
}
\seealso{
\code{\link{ObjFun_COMP_cpp}}, \code{\link{Gradient_COMP_cpp}},
\code{chickn::Sketch}, \code{chickn::GenerateFrequencies}, \href{https://CRAN.R-project.org/package=chickn}{chickn}
}
