% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/removetrendMPst.R
\name{removetrendMPst}
\alias{removetrendMPst}
\title{Median polish trend}
\usage{
removetrendMPst(MPST,eps=0.01, maxiter=10L)
}
\arguments{
\item{MPST}{object of class \code{\link{ConstructMPst}}}

\item{eps}{real number greater than \code{0}, default 0.01. A tolerance for convergence of median polish.}

\item{maxiter}{the maximum number of iterations. Default 10.}
}
\value{
data.frame with the following fields:

\item{ET}{indicate the time of a observation}

\item{x}{ spatial coordinates x}

\item{y}{ spatial coordinates y}

\item{z}{ spatial coordinates z}

\item{Trend}{trend calculated through median polish space - time}

\item{Value}{observed values}

\item{Residual}{\eqn{Residual = Value-Trend}}
}
\description{
Direct method to remove trend of spatio - temporal data througth median polish.
}
\details{
Robust method introduced for Cressie(1993) and enhanced by Berke(2001) to remove trend of a space - time process with data \eqn{\left\{y(\mathbf{s}_{abc},t), a=1,...,U; b=1,...,V; c=1,...,W, t=1,...,n  \right\} }
\deqn{Y(\mathbf{s}_{abc},t)= \mu_{y}(\mathbf{s}_{abc},t) + \delta _{abct}}
where
\deqn{\mu _{y}(\mathbf{s}_{abc},t)= \mu +\alpha _{a} + \beta _{b} + \xi _{c} + \tau _{t}}
and \eqn{\delta _{abct}} is a fluctuation arising from natural variability and from the measurement process. Additionally, \eqn{\mu} is an overall mean, \eqn{\alpha_{a}} is the \eqn{a}-th row effect, \eqn{\beta_{b}} is the effect \eqn{b}-th column effect, \eqn{\xi_{c}} is the \eqn{c}-th layer effect, \eqn{\tau _{t}} is the \eqn{t}-th time effect.
}
\examples{
## Not run:
data(Metadb)
x<-matrix(0,1,37)
for(i in 1:37){
 x[,i] <- 2007 + (seq(0, 36)/12)[i]
}
x<-as.Date (as.yearmon(x), frac = 1)
time = as.POSIXct(x, tz = "GMT")

MPST<-ConstructMPst(Metadb[,-c(1:4)],time,pts=Metadb[,2:4],Delta=c(7,6,5))
residuals<-removetrendMPst(MPST,eps=0.01, maxiter=2)
## End(Not run)
}
\references{
Berke, O. (2001). \emph{Modified median polish kriging and its application to the wolfcamp - aquifer data.} Environmetrics, 12(8):731-748.\href{http://onlinelibrary.wiley.com/doi/10.1002/env.495/abstract}{[link]}

Cressie, N. (1993). \emph{Statistics for spatial data.} Wiley series in probability and statistics.\href{http://www.wiley.com/WileyCDA/WileyTitle/productCd-1119115183.html}{[link]}
}

