% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{intensityDataset}
\alias{intensityDataset}
\title{Plot the intensity of values}
\usage{
intensityDataset(dataset, rankList, position, alpha)
}
\arguments{
\item{dataset}{Dataset containing numeric values}

\item{rankList}{List of ranked motifs}

\item{position}{Select by an integer a motif with his position}

\item{alpha}{Number of letter used to do the encode}
}
\value{
Pixelated dataset
}
\description{
Display the intensity of values and higthlight one motif
}
\examples{
#Launch all the workflow
candidates <- STSIdentifyCandidateSTMotifs(STMotif::example_dataset, 10, 10, 7, 3)
stmotifs <- STSIdentifySTMotifs(candidates, 1, 1)
sttightmotifs <- STSIdentifyTightSTMotifs(stmotifs, candidates$rectangles)
rankResult <- STSRankTightSTMotifs(sttightmotifs)

#Plot the result
intensityDataset(dataset = STMotif::example_dataset, rankResult, 1, 7)
}
