% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projINLA.R
\name{projINLA}
\alias{projINLA}
\title{Function to obtain projected estimates from INLA for each time and region.}
\usage{
projINLA(inla_mod, is.yearly = TRUE, year_range = c(1985, 2019),
  year_label = c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14",
  "15-19"), Amat = NULL, nsim = 1000)
}
\arguments{
\item{inla_mod}{output from \code{\link{fitINLA}}}

\item{is.yearly}{indicator for whether model is yearly or not}

\item{year_range}{range corresponding to year label}

\item{year_label}{vector of year string vector}

\item{Amat}{adjacency matrix}

\item{nsim}{number of simulations}
}
\value{
Results from RW2 model fit, including projection.
}
\description{
Function to obtain projected estimates from INLA for each time and region.
}
\examples{
\dontrun{
years <- levels(DemoData[[1]]$time)

# obtain direct estimates
data <- countrySummary_mult(births = DemoData, 
years = years,  
regionVar = "region", timeVar = "time", 
clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", 
geo.recode = NULL)

# obtain maps
geo <- DemoMap$geo
mat <- DemoMap$Amat

# Simulate hyper priors
priors <- simhyper(R = 2, nsamp = 1e+05, nsamp.check = 5000, Amat = mat, only.iid = TRUE)

# combine data from multiple surveys
data <- aggregateSurvey(data)

# Model fitting with INLA
years.all <- c(years, "15-19")
fit <- fitINLA(data = data, geo = geo, Amat = mat, 
year_names = years.all, year_range = c(1985, 2019), 
priors = priors, rw = 2, is.yearly=TRUE, 
m = 5, type.st = 4)
# Projection
out <- projINLA(fit, Amat = mat, is.yearly = TRUE)
plot(out, is.yearly=TRUE, is.subnational=TRUE) + ggplot2::ggtitle("Subnational yearly model")

}


}
