% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{plot_wind}
\alias{plot_wind}
\alias{plot_wind.swmpr}
\title{Create a wind rose}
\usage{
plot_wind(swmpr_in, ...)

\method{plot_wind}{swmpr}(swmpr_in, years = NULL, angle = 45,
  width = 1.5, breaks = 5, paddle = FALSE, grid.line = 10,
  max.freq = 30, cols = "GnBu", annotate = FALSE, main = NULL,
  type = "default", between = list(x = 1, y = 1),
  par.settings = NULL, strip = NULL, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{arguments passed to or from other methods}

\item{years}{numeric of years to plot, defaults to most recent}

\item{angle}{numeric for the number of degrees occupied by each spoke}

\item{width}{numeric for width of paddles if \code{paddle = TRUE}}

\item{breaks}{numeric for the number of break points in the wind speed}

\item{paddle}{logical for paddles at the ends of the spokes}

\item{grid.line}{numeric for grid line interval to use}

\item{max.freq}{numeric for the scaling used to set the maximum value of the radial limits (like zoom)}

\item{cols}{chr string for colors to use for plotting, can be any palette R recognizes or a collection of colors as a vector}

\item{annotate}{logical indicating if text is shown on the bottom of the plot for the percentage of observations as 'calm' and mean values}

\item{main}{chr string for plot title, defaults to station name and year plotted}

\item{type}{chr string for temporal divisions of the plot, defaults to whole year.  See details.}

\item{between}{list for lattice plot options, defines spacing between plots}

\item{par.settings}{list for optional plot formatting passed to \code{\link[lattice]{lattice.options}}}

\item{strip}{list for optional strip formatting passed to \code{\link[lattice]{strip.custom}}}
}
\value{
A wind rose plot
}
\description{
Create a wind rose from met data
}
\details{
This function is a convenience wrapper to \code{\link[openair]{windRose}}.  Most of the arguments are taken directly from this function.

The \code{type} argument can be used for temporal divisions of the plot.  Options include the entire year (\code{type = "default"}), seasons (\code{type = "season"}), months (\code{type = "month"}), or weekdays (\code{type = "weekday"}).  Combinations are also possible (see \code{\link[openair]{windRose}}).
}
\examples{
plot_wind(apaebmet)
}
\author{
Kimberly Cressman, Marcus Beck
}
\concept{analyze}
