% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.matrix.R, R/cor.mantel.R,
%   R/cor.matrix.partial.R, R/cor.matrix2.R, R/cor.procrustes.R, R/pro.matrix.R,
%   R/pro.matrix.partial.R, R/pro.matrix2.R
\encoding{UTF-8}
\name{cor.matrix}
\alias{cor.matrix}
\alias{cor.matrix.partial}
\alias{pro.matrix}
\alias{pro.matrix.partial}
\alias{cor.mantel}
\alias{cor.procrustes}
\alias{cor.matrix2}
\alias{pro.matrix2}
\title{Function to obtain the correlation between two matrices and partial matrix
correlation between three matrices.}
\usage{
cor.matrix(
  mx1,
  mx2,
  x,
  my1 = NULL,
  my2 = NULL,
  y,
  permute.my2 = FALSE,
  method = "pearson",
  dist = "euclidean",
  permutations = 999,
  norm = FALSE,
  norm.y = FALSE,
  strata = NULL,
  na.rm = FALSE,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)

cor.mantel(
  dist.x,
  dist.y,
  method = "pearson",
  permutations = 999,
  strata = NULL,
  na.rm = FALSE,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)

cor.matrix.partial(
  mx1,
  mx2,
  x,
  my1 = NULL,
  my2 = NULL,
  y,
  mz1 = NULL,
  mz2 = NULL,
  z,
  method = "pearson",
  dist = "euclidean",
  permute.my2 = FALSE,
  permute.mz2 = FALSE,
  permutations = 999,
  norm = FALSE,
  norm.y = FALSE,
  norm.z = FALSE,
  strata = NULL,
  na.rm = FALSE,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)

cor.matrix2(
  mx1,
  mx2,
  x,
  y,
  method = "pearson",
  dist = "euclidean",
  put.together = NULL,
  permutations = 999,
  strata = NULL,
  na.rm = FALSE,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)

cor.procrustes(
  x,
  y,
  permutations = 999,
  strata = NULL,
  na.rm = FALSE,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)

pro.matrix(
  mx1,
  mx2,
  x,
  my1 = NULL,
  my2 = NULL,
  y,
  permute.my2 = FALSE,
  permutations = 999,
  norm = FALSE,
  norm.y = FALSE,
  strata = NULL,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)

pro.matrix.partial(
  mx1,
  mx2,
  x,
  my1 = NULL,
  my2 = NULL,
  y,
  mz1 = NULL,
  mz2 = NULL,
  z,
  permute.my2 = FALSE,
  permute.mz2 = FALSE,
  permutations = 999,
  norm = FALSE,
  norm.y = FALSE,
  norm.z = FALSE,
  strata = NULL,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)

pro.matrix2(
  mx1,
  mx2,
  x,
  y,
  put.together = NULL,
  permutations = 999,
  strata = NULL,
  seqpermutation = NULL,
  parallel = NULL,
  newClusters = TRUE,
  CL = NULL
)
}
\arguments{
\item{mx1}{Matrix that multiplied by mx2 results in the matrix x.}

\item{mx2}{Matrix that when multiplied by mx1 results in the matrix x. See
`details` below.}

\item{x}{Matrix that will be correlated with the matrix y.}

\item{my1}{Matrix that multiplied by my2 results in the matrix y.}

\item{my2}{Matrix that when multiplied by my1 results in the matrix y. See
`details` below.}

\item{y}{Matrix that will be correlated with the matrix x.}

\item{permute.my2}{Logical argument (TRUE or FALSE) to specify if realize
parallel permutation in matrix my2.}

\item{method}{Correlation method, as accepted by cor: "pearson", "spearman"
or "kendall".}

\item{dist}{Dissimilarity index, as accepted by vegdist: "manhattan",
"euclidean", "canberra", "bray", "kulczynski", "jaccard", "gower",
"altGower", "morisita", "horn", "mountford", "raup" , "binomial" or "chao".}

\item{permutations}{Number of permutations in assessing significance.}

\item{norm}{Logical argument (TRUE or FALSE) to specify if x is standardized
within variables (Default norm = FALSE).}

\item{norm.y}{Logical argument (TRUE or FALSE) to specify if y is standardized
within variables (Default norm = FALSE).}

\item{strata}{Argument to specify restricting permutations within species
groups (Default strata = NULL).}

\item{na.rm}{Logical argument (TRUE or FALSE) to specify if pairwise
deletion of missing observations when computing dissimilarities (Default
na.rm = FALSE).}

\item{seqpermutation}{A set of predefined permutation, with the same dimensions of
permutations (Default seqpermutation = NULL).}

\item{parallel}{Number of parallel processes.  Tip: use parallel::detectCores() (Default parallel = NULL).}

\item{newClusters}{Logical argument (TRUE or FALSE) to specify if make new parallel
processes or use predefined socket cluster. Only if parallel is different of NULL (Default newClusters = TRUE).}

\item{CL}{A predefined socket cluster done with parallel package.}

\item{dist.x}{Dissimilarity matrices of class dist.}

\item{dist.y}{Dissimilarity matrices of class dist.}

\item{mz1}{Matrix that multiplied by mz2 results in the matrix z.}

\item{mz2}{Matrix that when multiplied by mz1 results in the matrix z. See
`details` below.}

\item{z}{Matrix whose effect will be removed from the correlation between x
and y.}

\item{permute.mz2}{Logical argument (TRUE or FALSE) to specify if realize
parallel permutation in matrix mz2.}

\item{norm.z}{Logical argument (TRUE or FALSE) to specify if z is standardized
within variables (Default norm = FALSE).}

\item{put.together}{List to specify group of traits. Each group specify receive the
same weight that one trait outside any group, in the way each group is considered
as unique trait (Default put.together = NULL). This argument must be a list, see
examples in \code{\link{syncsa}}.}
}
\value{
\item{Obs}{Correlation between matrices.} \item{p}{Significance
level based on permutations.}
}
\description{
The functions cor.matrix and cor.matrix.partial are similar the function
\code{\link{mantel}} and \code{\link{mantel.partial}}, although the significance
of the statistics is evaluated differently from Mantel. The functions pro.matrix
and pro.matrix.partial use symmetric Procrustes as a measure of concordance between
data sets. The function cor.mantel is similar to the function \code{\link{mantel}}, but
allows the use of a set of predefined permutation. For more details, see
\code{\link{syncsa}}.
}
\details{
The null model is based on permutations in the matrix mx2, typically the
matrices B, U and Q, except in the function cor.mantel when the permutations
are done in one of distance matrix.

Null model described by Pillar et al. (2009) and Pillar & Duarte (2010). For
more details on the matrices and the null model, see \code{\link{syncsa}}.
}
\references{
Pillar, V.D.; Duarte, L.d.S. (2010). A framework for
metacommunity analysis of phylogenetic structure. Ecology Letters, 13,
587-596.

Pillar, V.D., Duarte, L.d.S., Sosinski, E.E. & Joner, F. (2009).
Discriminating trait-convergence and trait-divergence assembly patterns in
ecological community gradients. Journal of Vegetation Science, 20, 334:348.
}
\seealso{
\code{\link{syncsa}}, \code{\link{organize.syncsa}}, \code{\link{mantel}},
\code{\link{procrustes}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
