% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_circos_links.R
\name{write_circos_links}
\alias{write_circos_links}
\title{write_circos_links}
\usage{
write_circos_links(df, include_colors = FALSE, file_name = "links.txt",
  file_path = NULL)
}
\arguments{
\item{df}{A data frame in the format of those returned by the `make_circos_links` function}

\item{include_colors}{Include colors generated by the `color_circos_links` function in the write file}

\item{file_name}{The desired file name. Defaults to links.txt in the current working directory}

\item{file_path}{The desired file path destination folder. Defaults to NULL}
}
\value{
Writes a Circos-compatible links file to the desired directory
}
\description{
A function that takes a data frame in the format of those returned by the `make_circos_links` function, and writes a "links"
file for Circos plotting
}
\examples{

df <- data.frame(lin_id = c(1,2), chr1 = c(1,1), band1 = c(1,1),
chr1_start = c(1,5), chr1_end = c(5,8),
n1 = c(5,3), chr2 = c(1,2), band2 = c(2,1),
chr2_start = c(8,1), chr2_end = c(13,5), n2 = c(5,5))

write_circos_links(df = df, file_name = "links.txt", file_path = tempdir())
}
\author{
Matthew Woodruff, Emory University
}
