% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Map_School_Buildings.R
\name{Map_School_Buildings}
\alias{Map_School_Buildings}
\title{Display data fom the school buildings database}
\usage{
Map_School_Buildings(
  data = NULL,
  field,
  order = NULL,
  level = "LAU",
  region_code = c(1:20),
  plot = "mapview",
  pal = "Blues",
  col_rev = FALSE,
  popup_height = 200,
  main_pos = "top",
  main = "",
  verbose = TRUE,
  input_shp = NULL,
  autoAbort = FALSE,
  ...
)
}
\arguments{
\item{data}{Object of class \code{list} or \code{tbl_df}, \code{tbl} and \code{data.frame}. Input data obtained as output of the function \code{\link{Group_DB_MIUR}}
If NULL, it will be downloaded automatically but not saved in the global environment. \code{NULL} by default.}

\item{field}{Character. The variable to display in the map.}

\item{order}{Character. The school order. Either \code{"Primary"}, \code{"Middle"}, or \code{"High"} (high school).
If \code{NULL}, an average of the three school orders will be displayed for the target variable. \code{NULL} by default.}

\item{level}{Character. The administrative level of detailed at which the target variable must be displayed.
Either \code{"LAU"}/\code{"Municipality"} or \code{"NUTS-3"}/\code{"Province"}. \code{"LAU"} by default.}

\item{region_code}{Numeric. The NUTS-2 codes of the units that must be displayed.
If the level is set to \code{"LAU"}, choosing a limited number of regions is recommended.
By default, \code{c(1:20)}, i.e. all Italian regions.}

\item{plot}{Character. The type of map to display; either \code{"mapview"} for interactive maps, or \code{"ggplot"} for static maps. \code{"mapview"} by default.}

\item{pal}{Character. The palette to use if the \code{"mapview"} mode is chose. \code{"Blues"} by default.}

\item{col_rev}{Logical. Whether the scale of the colour palette should be reverted or not, if the \code{"mapview"} mode is chosen. \code{FALSE} by default}

\item{popup_height}{Numeric. The height of the popup table in terms of pixels if the \code{"mapview"} mode is chosen. \code{200} by default.}

\item{main_pos}{Character. Where the header should be placed if the \code{ggplot} mode is chosen.
The header is located on the top if \code{"top"} is given as input, and above the legend scale otherwise. \code{"top"} by default.}

\item{main}{Character. The customary title to display in the \code{"ggplot"} rendering options}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.s}

\item{input_shp}{Object of class \code{sf}, \code{tbl_df}, \code{tbl}, \code{data.frame}. The relevant shapefiles of Italian administrative boudaries,
at the selected level of detail (LAU or NUTS-3). If \code{NULL} it is downloaded automatically but not saved in the global environment. \code{NULL} by default.}

\item{autoAbort}{Logical. In case any data must be retrieved, whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}

\item{...}{If \code{data} is not provided, the arguments to \code{\link{Group_DB_MIUR}}.}
}
\value{
If \code{plot == "mapview"}, an object of class \code{mapview}. Otherwise, if \code{plot == "ggplot"}, an object of class \code{gg} and \code{ggplot}.
}
\description{
This function displays a map of the data downloaded trough the \code{\link{Get_DB_MIUR}} function.
It supports two kinds of map:
\itemize{
  \item Interactive map (default option), which allows the user to visualize all the data in scope through the interactive popup, and
  \item Static map (ggplot), which can be easily exported in \code{.pdf} objects.
}
}
\examples{





  library(magrittr)

  DB23_MIUR <- example_input_DB23_MIUR \%>\%
    Util_DB_MIUR_num(track.deleted = FALSE) \%>\%
    Group_DB_MIUR(InnerAreas = FALSE, count_missing = FALSE)

  DB23_MIUR \%>\% Map_School_Buildings(field = "School_bus",
     order = "Primary",level = "NUTS-3",  plot = "ggplot",
     input_shp = example_Prov22_shp)

  DB23_MIUR \%>\% Map_School_Buildings(field = "Railway_transport",
     order = "High",level = "NUTS-3", plot = "ggplot",
     input_shp = example_Prov22_shp)

  DB23_MIUR \%>\% Map_School_Buildings(field = "Context_without_disturbances",
     order = "Middle",level = "NUTS-3", plot = "ggplot",
     input_shp = example_Prov22_shp, col_rev = TRUE)





}
