% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{colors}
\alias{colors}
\alias{rwb_colors}
\alias{rwb.colors}
\alias{rwg_colors}
\alias{rwg.colors}
\alias{ryg_colors}
\alias{ryg.colors}
\alias{cwm_colors}
\alias{cwm.colors}
\title{Various color palettes.}
\usage{
rwb_colors(n, alpha = 1, s = 0.9, v = 0.9)

rwb.colors(n, alpha = 1, s = 0.9, v = 0.9)

rwg_colors(n, alpha = 1, s = 0.9, v = 0.9)

rwg.colors(n, alpha = 1, s = 0.9, v = 0.9)

ryg_colors(n, alpha = 1, s = 0.9, v = 0.9)

ryg.colors(n, alpha = 1, s = 0.9, v = 0.9)

cwm_colors(n, alpha = 1, s = 0.9, v = 0.9)

cwm.colors(n, alpha = 1, s = 0.9, v = 0.9)
}
\arguments{
\item{n}{The number of colors (>= 1) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0, 1], see argument
\code{alpha =} in [hsv()].

[0, 1]: R:0,%201%5C
[hsv()]: R:hsv()}

\item{s}{The 'saturation' to be used to complete the HSV color descriptions.}

\item{v}{The 'value' to use for the HSV color descriptions.}
}
\description{
Create vectors of \code{n} contiguous colors.
}
\details{
\code{cwm_colors(s = 0.5, v = 1)} gives very similar colors to
\code{cm.colors()}.
\code{ryg_colors()} is similar to \code{rainbow(start = 0, end = 2/6)}.
The \code{xxx_colors()} (tidyverse name-compatible) and `xxx.colors()``
(grDevices name-compatible) functions are synonyms.
}
\examples{
# Draw color wheels with various palettes
opar <- par(mfrow = c(2, 2))
pie(rep(1, 11), col = cwm.colors(11), main = "Cyan - white - magenta")
pie(rep(1, 11), col = rwb.colors(11), main = "Red - white - blue")
pie(rep(1, 11), col = rwg.colors(11), main = "Red - white - green")
pie(rep(1, 11), col = ryg.colors(11), main = "Red - yellow - green")
par(opar)
}
\seealso{
\code{\link[=cm.colors]{cm.colors()}}, \code{\link[=colorRampPalette]{colorRampPalette()}}
}
\concept{
color palettes
}
\keyword{color}
