% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panels.R
\name{panels}
\alias{panels}
\alias{panel_reg}
\alias{panel.reg}
\alias{panel_ellipse}
\alias{panel.ellipse}
\alias{panel_cor}
\alias{panel.cor}
\alias{panel_smooth}
\title{More panel plots.}
\usage{
panel_reg(x, y, col = par("col"), bg = par("bg"), pch = par("pch"),
  cex = par("cex"), lwd = par("lwd"), line.reg = lm, line.col = "red",
  line.lwd = lwd, untf = TRUE, ...)

panel.reg(x, y, col = par("col"), bg = par("bg"), pch = par("pch"),
  cex = par("cex"), lwd = par("lwd"), line.reg = lm, line.col = "red",
  line.lwd = lwd, untf = TRUE, ...)

panel_ellipse(x, y, col = par("col"), bg = par("bg"), pch = par("pch"),
  cex = par("cex"), el.level = 0.7, el.col = "cornsilk",
  el.border = "red", major = TRUE, ...)

panel.ellipse(x, y, col = par("col"), bg = par("bg"), pch = par("pch"),
  cex = par("cex"), el.level = 0.7, el.col = "cornsilk",
  el.border = "red", major = TRUE, ...)

panel_cor(x, y, use = "everything", method = c("pearson", "kendall",
  "spearman"), alternative = c("two.sided", "less", "greater"), digits = 2,
  prefix = "", cex = par("cex"), cor.cex = cex, stars.col = "red", ...)

panel.cor(x, y, use = "everything", method = c("pearson", "kendall",
  "spearman"), alternative = c("two.sided", "less", "greater"), digits = 2,
  prefix = "", cex = par("cex"), cor.cex = cex, stars.col = "red", ...)

panel_smooth(x, y, col = par("col"), bg = NA, pch = par("pch"), cex = 1,
  col.smooth = "red", span = 2/3, iter = 3, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector of same length as \code{x}.}

\item{col}{The color of the points.}

\item{bg}{The background color for symbol used for the points.}

\item{pch}{The symbol used for the points.}

\item{cex}{The expansion factor used for the points.}

\item{lwd}{The line width.}

\item{line.reg}{A function that calculates coefficients of a straight line,
for instance, \code{\link[=lm]{lm()}}, or \code{\link[=rlm]{rlm()}} for robust linear regression.}

\item{line.col}{The color of the line.}

\item{line.lwd}{The width of the line.}

\item{untf}{Logical asking whether to untransform the straight line in case
one or both axis are in log scale.}

\item{...}{Further arguments to plot functions.}

\item{el.level}{The confidence level for the bivariate normal ellipse around
data; the default value of 0.7 draws an ellipse of roughly +/-1 sd.}

\item{el.col}{The color used to fill the ellipse.}

\item{el.border}{The color used to draw the border of the ellipse and the
standardized major axis.}

\item{major}{If \code{TRUE}, the standardized major axis is also drawn.}

\item{use}{One of \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"} (can be abbreviated).
Defines how the \code{\link[=cor]{cor()}} function behaves with missing observations.}

\item{method}{One of the three correlation coefficients \code{"pearson"}
(default), \code{"kendall"}, or \code{"spearman"}. Can be abbreviated.}

\item{alternative}{The alternative hypothesis in correlation test, see
\code{\link[=cor.test]{cor.test()}}.}

\item{digits}{The number of decimal digits to print when the correlation
coefficient is printed in the graph.}

\item{prefix}{A prefix (character string) to use before the correlation
coefficient printed in the graph.}

\item{cor.cex}{Expansion coefficient for text in printing correlation
coefficients.}

\item{stars.col}{The color used for significance stars (with: *** p < 0.001,
** p < 0.1, * p < 0.05, . p < 0.1.}

\item{col.smooth}{Color to be used by lines for drawing the smooths.}

\item{span}{Smoothing parameter f for \code{\link[=lowess]{lowess()}}, see there.}

\item{iter}{Number of robustness iterations for \code{\link[=lowess]{lowess()}}.}
}
\value{
These functions return nothing and are used for their side effect of
plotting in panels of composite plots.
}
\description{
Several panel plots that can be used with functions like \code{\link[=coplot]{coplot()}} and
[pairs))].

[pairs))]: R:pairs))
}
\details{
Theses functions should be used outside of the diagonal in
\code{\link[=pairs]{pairs()}}, or with \code{\link[=coplot]{coplot()}}, as they are bivariate plots.
}
\examples{
# Smooth lines in lower graphs and straight lines in upper graphs
pairs(trees, lower.panel = panel_smooth, upper.panel = panel_reg)
# Robust regression lines
library(MASS)  # For rlm()
pairs(trees, panel = panel_reg, diag.panel = panel_boxplot,
  reg.line = rlm, line.col = "blue", line.lwd = 2)
# A Double log graph
pairs(trees, lower.panel = panel_smooth, upper.panel = panel_reg, log = "xy")

# Graph suitables to explore correlations (take care there are potentially
# many simultaneous tests done here... So, you loose much power in the whole
# analysis... use it just as an indication!)
# Pearson's r
pairs(trees, lower.panel = panel_ellipse, upper.panel = panel_cor)
# Spearman's rho (ellipse and straight lines not suitable here!)
pairs(trees, lower.panel = panel_smooth, upper.panel = panel_cor,
  method = "spearman", span = 1)
# Several groups (visualize how bad it is to consider the whole set at once!)
pairs(iris[, -5], lower.panel = panel_smooth, upper.panel = panel_cor,
  method = "kendall", span = 1,
  col = c("red3", "blue3", "green3")[iris$Species])
# Now analyze correlation for one species only
pairs(iris[iris$Species == "virginica", -5], lower.panel = panel_ellipse,
  upper.panel = panel_cor)

# A coplot with custom panes
coplot(Petal.Length ~ Sepal.Length | Species, data = iris,
  panel = panel_ellipse)
}
\seealso{
\code{\link[=coplot]{coplot()}}, \code{\link[=pairs]{pairs()}}, \code{\link[=panel.smooth]{panel.smooth()}}, \code{\link[=lm]{lm()}}, \code{\link[=ellipse]{ellipse()}},
\code{\link[=cor]{cor()}} and \code{\link[=cor.test]{cor.test()}}
}
\author{
Philippe Grosjean \href{mailto:phgrosjean@sciviews.org}{phgrosjean@sciviews.org}, but code inspired from
\code{\link[=panel.smooth]{panel.smooth()}} in \strong{graphics} and \code{panel.car()} in package \strong{car}.
}
\concept{
panel plots
}
\keyword{aplot}
