% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{timing}
\alias{timing}
\title{Timing of R expressions.}
\usage{
timing(expr, gc.first = TRUE)
}
\arguments{
\item{expr}{Valid \R expression to be timed. If missing, \code{\link[=proc.time]{proc.time()}} is
used instead.}

\item{gc.first}{Logical - should a garbage collection be performed immediately
before the timing? Default is \code{TRUE}.}
}
\description{
Similar to \code{system.time()} but returns a more convenient 'difftime' object.
}
\examples{
test <- timing(Sys.sleep(0.5))
test
attr(test, "details")
}
\seealso{
\code{\link[=system.time]{system.time()}}
}
