% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\name{farina}
\alias{farina}
\title{Farina Index}
\usage{
farina(v, s, ...)

farina(v, s, ...)
}
\arguments{
\item{v}{A numeric vector of data values for votes each political party obtained.}

\item{s}{A numeric vector of data values for seats each political party obtained, the election outcome as seats.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A single score given the votes each party received and seats obtained.
}
\description{
Calculates the Farina index also referred to as the cosine proportionality score based on a vector of votes and a vector for the electoral outcome.
}
\examples{
# 2012 Queensland state elecion
pvotes= c(49.65, 26.66, 11.5, 7.53, 3.16, 1.47)
pseats = c(87.64, 7.87, 2.25, 0.00, 2.25, 0.00)

farina(pvotes, pseats)
}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}
\references{
Koppel, M., and A. Diskin. (2009) Measuring disproportionality, volatility and malapportionment: axiomatization and solutions. Social Choice and Welfare 33, no. 2: 281-286.
}
\seealso{
\code{\link{cox.shugart}}, \code{\link{inv.cox.shugart}}, \code{\link{politicalDiversity}}, \code{\link{grofman}}, \code{\link{gallagher}},  \code{\link{lijphart}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}.
}

