% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Untable.R
\encoding{UTF-8}
\name{Untable}
\alias{Untable}
\alias{Untable.data.frame}
\alias{Untable.default}
\title{Untable an Aggregated Data Frame}
\usage{
Untable(x, ...)

\method{Untable}{data.frame}(x, freq = "Freq", row.names = NULL, ...)

\method{Untable}{default}(x, dimnames = NULL, type = NULL,
  row.names = NULL, col.names = NULL, ...)
}
\arguments{
\item{x}{the table object as a data.frame, table, or, matrix.}

\item{freq}{the column name of count values.}

\item{row.names}{row names to add to \code{data.frame} if any.}

\item{dimnames}{set the dimnames of object if required.}

\item{type}{the type of variable. If NULL, ordered factor is returned.}

\item{col.names}{column names to add to the data.frame.}

\item{\dots}{Extra parameters ignored.}
}
\description{
A method for recovering a \code{data.frame} out of summarized data, i.e.  contingency table or aggregated data.
}
\examples{
gss <- data.frame(
expand.grid(sex=c("female", "male"),
party=c("dem", "indep", "rep")),
count=c(279,165,73,47,225,191))

print(gss) # aggregated data.frame

# Then expand it:
GSS <- Untable(gss, freq="count")
head(GSS)

# Expand from a table or xtable object:
# Fisher's Tea-Tasting Experiment data
 tea <- table(poured=c("Yes", "Yes", "Yes", "No","Yes","No", "No", "No"),
             guess=c("Yes", "Yes", "Yes", "Yes", "No", "No","No","No"))

Untable(tea)

# Expand with a vector of weights
Untable(c(3,3,3), dimnames=list(c("Brazil","Colombia","Argentina")))

}
\seealso{
\code{\link{expand.grid}}, \code{\link{gl}}.
}

