% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagrams.R
\name{tendency_diag}
\alias{tendency_diag}
\title{Tendency diagram from a data table containing tercile forecasts.}
\usage{
tendency_diag(
  dt,
  f = c("below", "normal", "above"),
  o = tc_cols(dt),
  by = NULL,
  pool = setdiff(dimvars(dt), by),
  dim.check = TRUE
)
}
\arguments{
\item{dt}{Data table containing tercile forecasts}

\item{f}{column names of the prediction columns}

\item{o}{column name of the observation column}

\item{by}{column names of grouping variables. Default is to not group.}

\item{pool}{column names of pooling variables (used for the dimension check). Default is all dimvars.}

\item{dim.check}{Logical. If TRUE, the function checks whether the columns in by and pool span the entire data table.}
}
\value{
If by == NULL a gg object, otherwise a list of gg objects that can be plotted by ggpubr::ggarrange (for example)
}
\description{
Tendency diagram from a data table containing tercile forecasts.
}
\examples{
dt = data.table(below = c(0.5,0.3,0),
                normal = c(0.3,0.3,0.7),
                above = c(0.2,0.4,0.3),
                tc_cat = c(-1,0,0),
                lon = 1:3)
print(dt)
pp = tendency_diag(dt)
if(interactive()) plot(pp)
}
