% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countWords.R
\name{countWords}
\alias{countWords}
\alias{countWords.Corpus}
\alias{countWords.character}
\alias{countWords.data.frame}
\alias{countWords.TermDocumentMatrix}
\alias{countWords.DocumentTermMatrix}
\title{Count words}
\usage{
countWords(
  x,
  aggregate = NULL,
  removeStopwords = TRUE,
  language = "english",
  ...
)

\method{countWords}{Corpus}(
  x,
  aggregate = NULL,
  removeStopwords = TRUE,
  language = "english",
  ...
)

\method{countWords}{character}(
  x,
  aggregate = NULL,
  removeStopwords = TRUE,
  language = "english",
  ...
)

\method{countWords}{data.frame}(
  x,
  aggregate = NULL,
  removeStopwords = TRUE,
  language = "english",
  ...
)

\method{countWords}{TermDocumentMatrix}(
  x,
  aggregate = NULL,
  removeStopwords = TRUE,
  language = "english",
  ...
)

\method{countWords}{DocumentTermMatrix}(
  x,
  aggregate = NULL,
  removeStopwords = TRUE,
  language = "english",
  ...
)
}
\arguments{
\item{x}{A vector of characters, a \code{data.frame}, an object of type 
\code{\link[tm]{Corpus}}, \code{\link[tm]{TermDocumentMatrix}} or
\code{\link[tm]{DocumentTermMatrix}}}

\item{aggregate}{A factor variable by which documents can be grouped. 
This helpful when joining e.g. news from the same day or move reviews
by the same author}

\item{removeStopwords}{Flag indicating whether to remove stopwords or not (default: yes)}

\item{language}{Language used for preprocessing operations (default: 
English)}

\item{...}{Additional parameters passed to function for e.g. 
preprocessing}
}
\value{
Result is a matrix with word counts for each document across
}
\description{
Function counts the words in each document
}
\examples{
documents <- c("This is a test", "an one more")

# count words (without stopwords)
countWords(documents)

# count all words (including stopwords)
countWords(documents, removeStopwords=FALSE)
}
