% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_network}
\alias{plot_network}
\title{Visualize a network}
\usage{
plot_network(network, compare_graph = NULL, as_subgraph = FALSE,
  node_scale = 4, edge_scale = 1, node_color = adjustcolor("orange",
  0.5), generate_layout = igraph::nicely, include_vertex_labels = TRUE,
  display_plot = TRUE, ...)
}
\arguments{
\item{network}{A 'network', 'network_module', or 'matrix' object.}

\item{compare_graph}{The plot of another network to use for comparison.}

\item{as_subgraph}{If TRUE, only nodes of positive degree will be shown.}

\item{node_scale}{Used for scaling of nodes.}

\item{edge_scale}{Used for scaling of edges.}

\item{node_color}{The color used for the nodes.}

\item{generate_layout}{A function to generate the layout of a graph; used
if coords is NULL. See ?igraph::layout_ for details. Other options include 
'igraph::as_star', 'igraph::in_circle', and 'igraph::with_fr', among many others.}

\item{include_vertex_labels}{If TRUE, the verticies will be labeled.}

\item{display_plot}{If TRUE (default), the plot will be generated and displayed.}

\item{...}{Additional arguments passed to plot.igraph().}
}
\value{
Creates a plot of the network and returns a graph object. 
The graph object can be passed back into a future call of plot.network() 
through the `compare_edge` argument, which will setup the plot for easier 
comparison between the old graph and the graph of `network`.
}
\description{
This function is used to plot a network. The 'network' argument can be a 
network object, network module, an adjacency matrix, or an association matrix. 
If the result of another plot is provided using the 'compare_graph' argument, 
then the layout of this network will be based on that plot.
}
\examples{
set.seed(0)
# Basic plotting for networks, modules, and matricies
nw <- random_network(10)
plot(nw)
module <- random_module(1:10)
plot(module)
adj_mat <- get_adjacency_matrix(nw)
plot_network(adj_mat)
# To compare multiple networks, the layout from the first plot can be used
# in subsequent plots using the second argument, `compare_graph`.
nw1 <- random_network(10)
nw2 <- remove_connections_to_node(nw1, 6, prob_remove = 1)
g <- plot(nw1)
plot(nw2, g)
# If the network contains many nodes of degree 0, plotting as subgraph
# may be preferred.
nw <- random_network(100, n_modules = 1)
plot(nw)
plot(nw, as_subgraph = TRUE)
# Networks can be plotted with modules highlighted.
nw <- random_network(100)
g <- plot_network(nw)
plot_modules(nw, g)
# For large networks, the vertex labels can clutter the graph; these can
# be removed using the `include_vertex_labels` argument.
nw <- random_network(250)
g <- plot(nw)
plot(nw, g, include = FALSE)
}
