% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{create_network_from_association_matrix}
\alias{create_network_from_association_matrix}
\title{Create a network object from an association matrix}
\usage{
create_network_from_association_matrix(association_matrix, ...)
}
\arguments{
\item{association_matrix}{The association matrix for the network. Since the
association matrix only provides information on the global connections, the
resulting 'network' object will consist of a single weighted module
containing these connections. The edge weights, i.e. the partial correlations,
will correspond to the nonzero values in the matrix.}

\item{...}{Additional arguments passed to
\code{\link{create_module_from_association_matrix}}.}
}
\value{
A network object.
}
\description{
Create a network object from an association matrix
}
\examples{
# Create a random weighted network and extract the association matrix from it.
nw <- random_network(10)
nw <- gen_partial_correlations(nw)
assoc_mat <- get_association_matrix(nw)
# Any association matrix can be used to directly create a network object.
# However, the created network will only contain one module.
nw_from_assoc <- create_network_from_association_matrix(assoc_mat)
all(get_adjacency_matrix(nw) == get_adjacency_matrix(nw_from_assoc))
}
