% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.bj.R
\name{test.bj}
\alias{test.bj}
\title{Multiple comparison test using Berk and Jones (BJ) statitics.}
\usage{
test.bj(prob, beta)
}
\arguments{
\item{prob}{- vector of input p-values.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}
}
\value{
pvalue - the p-value of the Berk-Jones test.

bjstat - the Berk-Jones statistic.

location - the order of the input p-values to obtain BJ statistic.
}
\description{
Multiple comparison test using Berk and Jones (BJ) statitics.
}
\examples{
test.bj(runif(10), 0.5)
#When the input are statistics#
stat.test = rnorm(20)
p.test = 1 - pnorm(stat.test)
test.bj(p.test, beta = 0.5)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Jager, Leah; Wellner, Jon A. "Goodness-of-fit tests via phi-divergences". Annals of Statistics 35 (2007).

3. Berk, R.H. & Jones, D.H. Z. "Goodness-of-fit test statistics that dominate the Kolmogorov statistics". Wahrscheinlichkeitstheorie verw Gebiete (1979) 47: 47.
}
\seealso{
\code{\link{stat.bj}} for the definition of the statistic.
}

