/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class VOSClusteringTechnique {
    protected Network network;
    protected Clustering clustering;
    protected double resolution;

    public VOSClusteringTechnique(Network network, double d) {
        this.network = network;
        this.clustering = new Clustering(network.nNodes);
        this.clustering.initSingletonClusters();
        this.resolution = d;
    }

    public VOSClusteringTechnique(Network network, Clustering clustering, double d) {
        this.network = network;
        this.clustering = clustering;
        this.resolution = d;
    }

    public Network getNetwork() {
        return this.network;
    }

    public Clustering getClustering() {
        return this.clustering;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public void setClustering(Clustering clustering) {
        this.clustering = clustering;
    }

    public void setResolution(double d) {
        this.resolution = d;
    }

    public double calcQualityFunction() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.network.nNodes; ++n) {
            int n2 = this.clustering.cluster[n];
            for (int i = this.network.firstNeighborIndex[n]; i < this.network.firstNeighborIndex[n + 1]; ++i) {
                if (this.clustering.cluster[this.network.neighbor[i]] != n2) continue;
                d += this.network.edgeWeight[i];
            }
        }
        d += this.network.totalEdgeWeightSelfLinks;
        double[] dArray = new double[this.clustering.nClusters];
        for (n = 0; n < this.network.nNodes; ++n) {
            int n3 = this.clustering.cluster[n];
            dArray[n3] = dArray[n3] + this.network.nodeWeight[n];
        }
        for (n = 0; n < this.clustering.nClusters; ++n) {
            d -= dArray[n] * dArray[n] * this.resolution;
        }
        return d /= 2.0 * this.network.getTotalEdgeWeight() + this.network.totalEdgeWeightSelfLinks;
    }

    public boolean runLocalMovingAlgorithm() {
        return this.runLocalMovingAlgorithm(new Random());
    }

    public boolean runLocalMovingAlgorithm(Random random) {
        int n;
        if (this.network.nNodes == 1) {
            return false;
        }
        boolean bl = false;
        double[] dArray = new double[this.network.nNodes];
        int[] nArray = new int[this.network.nNodes];
        for (n = 0; n < this.network.nNodes; ++n) {
            int n2 = this.clustering.cluster[n];
            dArray[n2] = dArray[n2] + this.network.nodeWeight[n];
            int n3 = this.clustering.cluster[n];
            nArray[n3] = nArray[n3] + 1;
        }
        int n4 = 0;
        int[] nArray2 = new int[this.network.nNodes];
        for (n = 0; n < this.network.nNodes; ++n) {
            if (nArray[n] != 0) continue;
            nArray2[n4] = n;
            ++n4;
        }
        int[] nArray3 = Arrays2.generateRandomPermutation(this.network.nNodes, random);
        double[] dArray2 = new double[this.network.nNodes];
        int[] nArray4 = new int[this.network.nNodes - 1];
        int n5 = 0;
        n = 0;
        do {
            int n6;
            int n7;
            int n8 = nArray3[n];
            int n9 = 0;
            for (n7 = this.network.firstNeighborIndex[n8]; n7 < this.network.firstNeighborIndex[n8 + 1]; ++n7) {
                n6 = this.clustering.cluster[this.network.neighbor[n7]];
                if (dArray2[n6] == 0.0) {
                    nArray4[n9] = n6;
                    ++n9;
                }
                int n10 = n6;
                dArray2[n10] = dArray2[n10] + this.network.edgeWeight[n7];
            }
            int n11 = this.clustering.cluster[n8];
            dArray[n11] = dArray[n11] - this.network.nodeWeight[n8];
            int n12 = this.clustering.cluster[n8];
            nArray[n12] = nArray[n12] - 1;
            if (nArray[this.clustering.cluster[n8]] == 0) {
                nArray2[n4] = this.clustering.cluster[n8];
                ++n4;
            }
            int n13 = -1;
            double d = 0.0;
            for (n7 = 0; n7 < n9; ++n7) {
                n6 = nArray4[n7];
                double d2 = dArray2[n6] - this.network.nodeWeight[n8] * dArray[n6] * this.resolution;
                if (d2 > d || d2 == d && n6 < n13) {
                    n13 = n6;
                    d = d2;
                }
                dArray2[n6] = 0.0;
            }
            if (d == 0.0) {
                n13 = nArray2[n4 - 1];
                --n4;
            }
            int n14 = n13;
            dArray[n14] = dArray[n14] + this.network.nodeWeight[n8];
            int n15 = n13;
            nArray[n15] = nArray[n15] + 1;
            if (n13 == this.clustering.cluster[n8]) {
                ++n5;
            } else {
                this.clustering.cluster[n8] = n13;
                n5 = 1;
                bl = true;
            }
            int n16 = n = n < this.network.nNodes - 1 ? n + 1 : 0;
        } while (n5 < this.network.nNodes);
        int[] nArray5 = new int[this.network.nNodes];
        this.clustering.nClusters = 0;
        for (n = 0; n < this.network.nNodes; ++n) {
            if (nArray[n] <= 0) continue;
            nArray5[n] = this.clustering.nClusters++;
        }
        for (n = 0; n < this.network.nNodes; ++n) {
            this.clustering.cluster[n] = nArray5[this.clustering.cluster[n]];
        }
        return bl;
    }

    public boolean runLouvainAlgorithm() {
        return this.runLouvainAlgorithm(new Random());
    }

    public boolean runLouvainAlgorithm(Random random) {
        VOSClusteringTechnique vOSClusteringTechnique;
        boolean bl;
        if (this.network.nNodes == 1) {
            return false;
        }
        boolean bl2 = this.runLocalMovingAlgorithm(random);
        if (this.clustering.nClusters < this.network.nNodes && (bl = (vOSClusteringTechnique = new VOSClusteringTechnique(this.network.createReducedNetwork(this.clustering), this.resolution)).runLouvainAlgorithm(random))) {
            bl2 = true;
            this.clustering.mergeClusters(vOSClusteringTechnique.clustering);
        }
        return bl2;
    }

    public boolean runIteratedLouvainAlgorithm(int n) {
        return this.runIteratedLouvainAlgorithm(n, new Random());
    }

    public boolean runIteratedLouvainAlgorithm(int n, Random random) {
        boolean bl;
        int n2 = 0;
        do {
            bl = this.runLouvainAlgorithm(random);
        } while (++n2 < n && bl);
        return n2 > 1 || bl;
    }

    public boolean runLouvainAlgorithmWithMultilevelRefinement() {
        return this.runLouvainAlgorithmWithMultilevelRefinement(new Random());
    }

    public boolean runLouvainAlgorithmWithMultilevelRefinement(Random random) {
        VOSClusteringTechnique vOSClusteringTechnique;
        boolean bl;
        if (this.network.nNodes == 1) {
            return false;
        }
        boolean bl2 = this.runLocalMovingAlgorithm(random);
        if (this.clustering.nClusters < this.network.nNodes && (bl = (vOSClusteringTechnique = new VOSClusteringTechnique(this.network.createReducedNetwork(this.clustering), this.resolution)).runLouvainAlgorithmWithMultilevelRefinement(random))) {
            bl2 = true;
            this.clustering.mergeClusters(vOSClusteringTechnique.clustering);
            this.runLocalMovingAlgorithm(random);
        }
        return bl2;
    }

    public boolean runIteratedLouvainAlgorithmWithMultilevelRefinement(int n) {
        return this.runIteratedLouvainAlgorithmWithMultilevelRefinement(n, new Random());
    }

    public boolean runIteratedLouvainAlgorithmWithMultilevelRefinement(int n, Random random) {
        boolean bl;
        int n2 = 0;
        do {
            bl = this.runLouvainAlgorithmWithMultilevelRefinement(random);
        } while (++n2 < n && bl);
        return n2 > 1 || bl;
    }

    public boolean runSmartLocalMovingAlgorithm() {
        return this.runSmartLocalMovingAlgorithm(new Random());
    }

    public boolean runSmartLocalMovingAlgorithm(Random random) {
        if (this.network.nNodes == 1) {
            return false;
        }
        boolean bl = this.runLocalMovingAlgorithm(random);
        if (this.clustering.nClusters < this.network.nNodes) {
            int n;
            VOSClusteringTechnique vOSClusteringTechnique;
            int n2;
            Network[] networkArray = this.network.createSubnetworks(this.clustering);
            int[][] nArray = this.clustering.getNodesPerCluster();
            this.clustering.nClusters = 0;
            int[] nArray2 = new int[networkArray.length];
            for (n2 = 0; n2 < networkArray.length; ++n2) {
                vOSClusteringTechnique = new VOSClusteringTechnique(networkArray[n2], this.resolution);
                vOSClusteringTechnique.runLocalMovingAlgorithm(random);
                for (n = 0; n < networkArray[n2].nNodes; ++n) {
                    this.clustering.cluster[nArray[n2][n]] = this.clustering.nClusters + vOSClusteringTechnique.clustering.cluster[n];
                }
                this.clustering.nClusters += vOSClusteringTechnique.clustering.nClusters;
                nArray2[n2] = vOSClusteringTechnique.clustering.nClusters;
            }
            vOSClusteringTechnique = new VOSClusteringTechnique(this.network.createReducedNetwork(this.clustering), this.resolution);
            n2 = 0;
            for (n = 0; n < nArray2.length; ++n) {
                for (int i = 0; i < nArray2[n]; ++i) {
                    vOSClusteringTechnique.clustering.cluster[n2] = n;
                    ++n2;
                }
            }
            vOSClusteringTechnique.clustering.nClusters = nArray2.length;
            bl |= vOSClusteringTechnique.runSmartLocalMovingAlgorithm(random);
            this.clustering.mergeClusters(vOSClusteringTechnique.clustering);
        }
        return bl;
    }

    public boolean runIteratedSmartLocalMovingAlgorithm(int n) {
        return this.runIteratedSmartLocalMovingAlgorithm(n, new Random());
    }

    public boolean runIteratedSmartLocalMovingAlgorithm(int n, Random random) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            bl |= this.runSmartLocalMovingAlgorithm(random);
        }
        return bl;
    }

    public int removeCluster(int n) {
        int n2;
        int n3;
        double[] dArray = new double[this.clustering.nClusters];
        double[] dArray2 = new double[this.clustering.nClusters];
        for (n3 = 0; n3 < this.network.nNodes; ++n3) {
            int n4 = this.clustering.cluster[n3];
            dArray[n4] = dArray[n4] + this.network.nodeWeight[n3];
            if (this.clustering.cluster[n3] != n) continue;
            for (n2 = this.network.firstNeighborIndex[n3]; n2 < this.network.firstNeighborIndex[n3 + 1]; ++n2) {
                int n5 = this.clustering.cluster[this.network.neighbor[n2]];
                dArray2[n5] = dArray2[n5] + this.network.edgeWeight[n2];
            }
        }
        n3 = -1;
        double d = 0.0;
        for (n2 = 0; n2 < this.clustering.nClusters; ++n2) {
            double d2;
            if (n2 == n || !(dArray[n2] > 0.0) || !((d2 = dArray2[n2] / dArray[n2]) > d)) continue;
            n3 = n2;
            d = d2;
        }
        if (n3 >= 0) {
            for (n2 = 0; n2 < this.network.nNodes; ++n2) {
                if (this.clustering.cluster[n2] != n) continue;
                this.clustering.cluster[n2] = n3;
            }
            if (n == this.clustering.nClusters - 1) {
                this.clustering.nClusters = Arrays2.calcMaximum(this.clustering.cluster) + 1;
            }
        }
        return n3;
    }

    public void removeSmallClusters(int n) {
        int n2;
        VOSClusteringTechnique vOSClusteringTechnique = new VOSClusteringTechnique(this.network.createReducedNetwork(this.clustering), this.resolution);
        int[] nArray = this.clustering.getNNodesPerCluster();
        do {
            n2 = -1;
            int n3 = n;
            for (int i = 0; i < vOSClusteringTechnique.clustering.nClusters; ++i) {
                if (nArray[i] <= 0 || nArray[i] >= n3) continue;
                n2 = i;
                n3 = nArray[i];
            }
            if (n2 < 0) continue;
            n3 = vOSClusteringTechnique.removeCluster(n2);
            if (n3 >= 0) {
                int n4 = n3;
                nArray[n4] = nArray[n4] + nArray[n2];
            }
            nArray[n2] = 0;
        } while (n2 >= 0);
        this.clustering.mergeClusters(vOSClusteringTechnique.clustering);
    }
}

