% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring.R
\name{AddModuleScore}
\alias{AddModuleScore}
\title{Calculate module scores for gene expression programs in single cells}
\usage{
AddModuleScore(object, genes.list = NULL, genes.pool = NULL, n.bin = 25,
  seed.use = 1, ctrl.size = 100, use.k = FALSE, enrich.name = "Cluster")
}
\arguments{
\item{object}{Seurat object}

\item{genes.list}{Gene expression programs in list}

\item{genes.pool}{List of genes to check expression levels agains, defaults to rownames(x = object@data)}

\item{n.bin}{Number of bins of aggregate expression levels for all analyzed genes}

\item{seed.use}{Random seed for sampling}

\item{ctrl.size}{Number of control genes selected from the same bin per analyzed gene}

\item{use.k}{Use gene clusters returned from DoKMeans()}

\item{enrich.name}{Name for the expression programs}
}
\value{
Returns a Seurat object with module scores added to object@meta.data
}
\description{
Calculate the average expression levels of each program (cluster) on single cell level,
subtracted by the aggregated expression of control gene sets.
All analyzed genes are binned based on averaged expression, and the control genes are
randomly selected from each bin.
}
\examples{
cd_genes <- list(c(
  'CD79B',
  'CD79A',
  'CD19',
  'CD180',
  'CD200',
  'CD3D',
  'CD2',
  'CD3E',
  'CD7',
  'CD8A',
  'CD14',
  'CD1C',
  'CD68',
  'CD9',
  'CD247'
))
pbmc_small <- AddModuleScore(
  object = pbmc_small,
  genes.list = cd_genes,
  ctrl.size = 5,
  enrich.name = 'CD_Genes'
)
head(x = pbmc_small@meta.data)

}
\references{
Tirosh et al, Science (2016)
}
