% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortform_plots.R
\name{plot}
\alias{plot}
\alias{plot.antcolony}
\alias{plot.tabu}
\alias{plot.simulatedAnnealing}
\title{Plot Functions for ShortForm Objects}
\usage{
\method{plot}{antcolony}(x, type = "all", ...)

\method{plot}{tabu}(x, ...)

\method{plot}{simulatedAnnealing}(x, ...)
}
\arguments{
\item{x}{An object with one of the following classes: \code{antcolony},
\code{tabu}, or \code{simulatedAnnealing}.}

\item{type}{A character string. One of "all", "pheromone", "gamma", "beta", or
"variance". Matched literally. Only used with objects of class \code{antcolony}.}

\item{...}{Not used with the current S3 method implementation.}
}
\description{
These are the plot functions for the results objects created by the 
\pkg{ShortForm} package (objects of class \code{antcolony}, \code{tabu},
and \code{simulatedAnnealing}).
}
\details{
Objects of classes \code{tabu} and \code{simulatedAnnealing} produce a 
single plot which show the changes in the objective function across each 
iteration of the algorithm. Objects of class \code{antcolony} can produce
up to four plots which show the changes in the pheromone levels for each
item, changes in the average standardized regression coefficients of the
model (gammas and betas), and changes in the amount of variance explained 
in the model across each iteration of the algorithm.

These functions do not currently allow users to modify the resulting
plots directly, but the objects produces are \pkg{ggplot2} objects which
should allow for additional user customization.
}
