% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplineFitDepFct.R
\name{SplineFitDepFct}
\alias{SplineFitDepFct}
\title{Fit a dependence function by spline smoothing}
\usage{
SplineFitDepFct(x, y = NULL, alpha = 0.01, integ.value)
}
\arguments{
\item{x, y}{vectors giving the coordinates of the points to be approximated. Alternatively a single plotting structure can be specified: see \code{\link{xy.coords}}.}

\item{alpha}{real, the smoothing parameter for the smoothing splines.}

\item{integ.value}{real, non-negative value that should be less than two; see \sQuote{Details}}
}
\value{
A function, created by \code{\link{splinefun}}, that evaluates the natural cubic spline that was fitted to the data.
}
\description{
Given estimates for the dependence function of a bivariate extreme value copula at specified points, this function fits a natural cubic smoothing spline, that is constrained to fulfill all the conditions of a dependence function, to the given estimates via quadratic programming.
}
\details{
\code{integ.value} should be between 0 and 2.  If a value is specified, then an additional constraint is added to the quadratic program to ensure that the integeral (over 0 to 1) of the second derivative of the spline is larger or equal to \code{integ.value}.  Choosing values close to 2 may lead to quadratic programms on which \code{\link{solve.QP}} reports inconsistent constraints.
}
\examples{
## Data from Hall and Tajvidi (2004, ANZJS)
EstDF2 <- NonparEstDepFct(MaxTemp, convex = FALSE)

## Plot modified Pickands Function and area in which
## dependence function must lie
plot(EstDF2, ylim = c(0.5,1), xlab = "w", ylab = "A(w)", type="l", lty="longdash")
polygon(c(0, 0.5, 1, 0), c(1, 0.5, 1, 1))

## Fit spline to Pickands function and add to plot
splfit <- SplineFitDepFct(EstDF2)
curve(splfit, n = 301, add = TRUE, lty = "dashed")

}
\references{
Hall, P. and Tajvidi, N. (2000). Distribution and dependence-function estimation for bivariate extreme-value distributions.  \emph{Bernoulli} \bold{6}(5), 835--844. Doi:10.2307/3318758.

Hall, P. and Tajvidi, N. (2004). Prediction regions for bivariate extreme events. \emph{Australian & New Zealand Journal of Statistics} \bold{46}(1), 99--112. Doi:10.1111/j.1467-842X.2004.00316.x.
}
\seealso{
\code{\link{NonparEstDepFct}}, \code{\link{NewBEVSplineCopula}}
}
\author{
Nader Tajvidi <Nader.Tajvidi@matstat.lu.se>

Berwin A Turlach <Berwin.Turlach@gmail.com>
}
\keyword{smooth}
