% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sol_eqeff.R
\name{sol_eqeff}
\alias{sol_eqeff}
\title{Expression of null response coefficient}
\usage{
sol_eqeff(tau_fun,E_ini_fun,A_fun,B_fun,correl_fun)
}
\arguments{
\item{tau_fun}{Numeric. Driving variable of the system}

\item{E_ini_fun}{Numeric vector of initial concentrations}

\item{A_fun}{Numeric vector of activities}

\item{B_fun}{Numeric vector of global co-regulation coefficients. Same length as \code{E_ini_fun}.}

\item{correl_fun}{Character string indicating the constraint abbreviation. Three constraints are allowed here: \code{"RegNeg"}, \code{"CRPos"} and \code{"CRNeg"}.}
}
\value{
A numeric value
}
\description{
\emph{(Utilitary function)}. Gives result of a transformed expression of the response coefficient
}
\details{
Null this expression corresponds to search the effective equilibrium in case of regulation, with or without competition.
}
\references{
Coton et al. (2021)
}
\seealso{
See function \code{\link{predict_eff}} to compute the effective equilibrium.
}
